#include <u.h>
#include <libc.h>
#include <auth.h>
#include <fcall.h>
#include "dat.h"
#include "fns.h"

AuthRpc*   
auth_allocrpc_wrap(void)
{
	int afd;
	AuthRpc *rpc;

	afd = open("/mnt/factotum/rpc", ORDWR);
	if(afd < 0){
		werrstr("opening /mnt/factotum/rpc: %r");
		return nil;
	}
	if((rpc = auth_allocrpc(afd)) == nil){
		return nil;
	}
	return rpc;
}


int
post9pservice(int fd, char *srv)
{
	int f;
	char buf[128];

	fprint(2, "post...\n");
	snprint(buf, sizeof buf, "/srv/%.28s", srv);
	f = create(buf, OWRITE, 0600);
	if(f < 0)
		sysfatal("create(%s): %r", buf);
	sprint(buf, "%d", fd);
	if(write(f, buf, strlen(buf)) != strlen(buf))
		sysfatal("write srv: %r");
	return(1);
}

char*
getdialstr(char *name)
{
	char *ds;
	
	ds = smprint("/srv/%.28s", name); 
	return(ds);
}

void
usage(void)
{
	fprint(2, "usage: recover [-s] [-d] [net!]host [srvname] [spec]\n");
	sysfatal("usage");
}