#include <u.h>
#include <libc.h>
#include <fcall.h>
#include "dat.h"
#include <auth.h>
#include "fns.h"


Idmap fidmap;
uvlong fidgen = 0x100000000LL;

Fid*
lookuplfid(uvlong local)
{
	return (Fid*)lookuplocal(&fidmap, local);
}

Fid*
lookuprfid(ulong remote)
{
	return (Fid*)lookupremote(&fidmap, remote);
}

void
freefid(Fid *f)
{
	free(f->cname.name);
	free(f->sname.name);
	freeid(&fidmap, &f->fid);
}

Fid*
allocfid(uvlong lfid)
{
	return (Fid*)allocid(&fidmap, lfid, sizeof(Fid), nil);
}
