enum {
	MAXFID = 4096,			/* maximum remote fid used */
	ULONGBITS = 8*sizeof(ulong),
	NHASH = 128,
	MAXMSG = 8192,
	MAXPKT = MAXMSG+IOHDRSZ,
};

typedef struct Attach	Attach;
typedef struct Cname	Cname;
typedef struct Id		Id;
typedef struct Idmap	Idmap;
typedef struct Fid		Fid;
typedef struct Req		Req;

struct Attach {	/* one per attach specifier */
	Attach *link;
	char *aname;	/* attach specifier */
	Fid *rootfid;	/* root fid of attach, internal use only */
	Qid rootqid;	/* root qid of attach */
	int gen;		/* gen. number of connection that saw last successful attach */
	int rgen;		/* gen. number of connection that last started to recover this */
	ulong mcount;	/* mount id for authenticators */
};

struct Cname {	/* path name; two per fid */
	char *name;
	long len;
};

struct Id {
	Id *llink;		/* local id list hash link */
	Id *rlink;		/* remote id list hash link */
	uvlong local;	/* local id */
	ulong remote;	/* remote id */
};

struct Idmap {
	Id *lhash[NHASH];
	Id *rhash[NHASH];
	ulong v[MAXFID/ULONGBITS];
};

struct Fid {	/* one per fid */
	Id fid;
	int gen;		/* gen. number of connection that saw last successful fid use */
	int rgen;		/* gen. number of connection that last started to recover fid */
	Cname cname;	/* what local fid corresponds to */
	Cname sname;	/* what remote fid currently corresponds to (goal is cname) */
	Attach *attach;
	uchar isopen;
	uchar omode;
	uchar orclose;	/* remove on close? */
	uchar clunkme;	/* clunk this fid asap */
	u32int	dirscount;  /*point reading dir in server, goes to 0 when redial in internal Rwalk*/
	u32int	dirccount;  /*point reading dir in client, stays between redials*/
	uchar	type;
	ulong	vers;
};

struct Req {
	Id tag;
	Fid *fid;		/* analogues of Fcall fields; fid ≡ lookupfid(fcall.fid), etc. */
	Fid *newfid;
	uchar internal;	/* was this generated internally as part of fid recovery? */
	uchar isattach;	/* is this a Tattach message in Tclone's clothing? */
	uchar isclunk;	/* is this a Tclunk message in Tremove's clothing? */
	uchar flushing;	/* have we sent a Tflush trying to flush this tag? */
	Fcall fcall;		/* actual Fcall we want to satisfy; fids are remote */
	int	gen;
	uchar buf[MAXPKT];	/*the buffer of the message*/
};

extern int netfd;
extern int srvfd;
extern char *dialstring;
extern char *eve;
extern int (*doconnect)(char*);
extern int chatty;
extern int gen;
extern ulong taggen;
extern uvlong fidgen;
extern QLock	thelock;
extern Attach *attachlist;
extern char *logfile;
extern int nreq;
extern int (*getkey)(char*);
extern Fcall last[256];
int nlast;
extern ulong currmsize;
