typedef struct Header Header;
typedef struct Info Info;
typedef struct Data Data;
typedef struct Indices Indices;

typedef enum {
	Reserved = 0,
	Layer3 = 1,
	Layer2 = 2,
	Layer1 = 3
} Layer;

typedef enum {
	Stereo = 0,
	Joint,
	Dualchan,
	Singlechan
} Mode;

struct Header {
	uint id;
	Layer layer;
	uint pro;
	uint rate;
	uint freq;
	uint pad;
	uint priv;
	Mode mode;
	uint ext;
	uint copy;
	uint orig;
	uint emph;
};

struct Info {
	uint begin;
	uint priv;
	uint scfsi[2][4];
	uint len[2][2];
	uint big[2][2];
	uint gain[2][2];
	uint com[2][2];
	uint swtch[2][2];
	uint block[2][2];
	uint mblk[2][2];
	uint tblsel[2][2][3];
	uint sblk[2][2][3];
	uint reg0[2][2];
	uint reg1[2][2];
	uint pflag[2][2];
	uint scale[2][2];
	uint sel[2][2];
	uint cnt[2][2];
};

struct Data {
	uint sfl[2][2][21];
	uint sfs[2][2][12][3];
	float is[2][2][576];
};

struct Indices {
	uint l[23];
	uint s[14];
};

#define EOF (-1)

extern uint freq[3];
extern uint datatop;
extern float synthtbl[512];
extern uint datatop;
extern Header head;
extern Info info;
extern Data data;
extern Indices idcs[3];

extern void warn(char *msg, ...);
extern void audiowrite(uint *sa, uint nsa);
extern uint getmainbits(uint n);
extern uint getmainbit(void);
extern int setmainpos(uint bitpos);
extern uint getmainpos(void);
extern void readhuff(uint part2, uint gr, uint ch);
extern int decode(void);
extern void initdecode(void);
