#include <u.h>
#include <libc.h>
#include <bio.h>
#include "mp3dec.h"

uint datatop = 0;
uint freq[3] = { 44100, 48000, 32000 };
Indices idcs[3] = {
	{{ 0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 52, 62,
		74, 90, 110, 134, 162, 196, 238, 288, 342, 418, 576},
		{ 0, 4, 8, 12, 16, 22, 30, 40, 52, 66, 84, 106, 136, 192 }},
	{{ 0, 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88, 106, 128,
		156, 190, 230, 276, 330, 384, 576},
		{ 0, 4, 8, 12, 16, 22, 28, 38, 50, 64, 80, 100, 126, 192 }},
	{{ 0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82, 102, 126, 156,
		194, 240, 296, 364, 448, 550, 576},
		{ 0, 4, 8, 12, 16, 22, 30, 42, 58, 78, 104, 138, 180, 192 }}
};
Header head;
Info info;
Data data;
static Biobuf *bin, bout;
static int init = 0;
static uint infovec[32+4], datavec[2*1024];
static uint *infoptr, infoidx, *dataptr, dataidx;
static uint sfsizes[16][2] = {
	{0, 0}, {0, 1}, {0, 2}, {0, 3}, {3, 0}, {1, 1}, {1, 2}, {1, 3},
	{2, 1}, {2, 2}, {2, 3}, {3, 1}, {3, 2}, {3, 3}, {4, 2}, {4, 3}
};
static uint rates[3][15] = {
	{ 0, 32000, 64000, 96000, 128000, 160000, 192000, 224000,
	256000, 288000, 320000, 352000, 384000, 416000, 448000 },
	{ 0, 32000, 48000, 56000, 64000, 80000, 96000, 112000,
	128000, 160000, 192000, 224000, 256000, 320000, 384000 },
	{ 0, 32000, 40000, 48000, 56000, 64000, 80000, 96000,
	112000, 128000, 160000, 192000, 224000, 256000, 320000 }
};

void
warn(char* msg, ...)
{
	char buf[500];
	va_list arg;

	va_start(arg, msg);
	vseprint(buf, buf+sizeof(buf), msg, arg);
	va_end(arg);
	fprint(2, "%s: %s\n", argv0, buf);
}

static uint
getbyte(void)
{
	int val;

	val = Bgetc(bin) & 0xff;
	if(val == Beof)
		val = EOF;	
	return (uint) val;
}

static int
getbytes(uint nob, uint vec[])
{
	int i;
	uint val;

	for(i = 0; i < nob; i++){
		val = getbyte();
		if(val == EOF)
			return EOF;
		else
			vec[i] = val;
	}
	return 0;
}

static void 
getinfo(uint size)
{
	if(getbytes(size, infovec) != 0){
		warn("couldn't read sideinfo");
		return;
	}
	infoptr = &infovec[0];
	infoidx = 0;
}

static int
getmaindata(uint size, uint begin)
{
	int i;

	if(begin > datatop){
		getbytes(size, &datavec[datatop]);
		dataptr = &datavec[0];
		dataidx = 0;
		datatop += size;
		return -1;	
	}

	for(i = 0; i < begin; i++)
		datavec[i] = datavec[datatop-begin+i];
	getbytes(size, &datavec[begin]);
	dataptr = &datavec[0];
	dataidx = 0;
	datatop = begin + size;

	return 0;
}

static int
readhead(void)
{
	uint b1, b2, b3, b4, h;

	b1 = getbyte();
	b2 = getbyte();
	b3 = getbyte();
	b4 = getbyte();
	if((b1 == EOF) || (b2 == EOF) || (b3 == EOF) || (b4 == EOF))
		return EOF;
	h = (b1<<24) | (b2<<16) | (b3<<8) | (b4<<0);

	if((h & 0xfff00000) != 0xfff00000){
		while(1){
			b1 = b2;
			b2 = b3;
			b3 = b4;
			b4 = getbyte();
			if(b4 == EOF)
				return EOF;
			h = (b1<<24) | (b2<<16) | (b3<<8) | (b4<<0);
			if((h & 0xfff00000) == 0xfff00000)
				break;
		}
	}

	head.id = (h & 0x00080000) >> 19;
	head.layer = (h & 0x00060000) >> 17;
	head.pro = (h & 0x00010000) >> 16;
	head.rate = (h & 0x0000f000) >> 12;
	head.freq = (h & 0x00000c00) >> 10;
	head.pad = (h & 0x00000200) >> 9;
	head.priv = (h & 0x00000100) >> 8;
	head.mode = (h & 0x000000c0) >> 6;
	head.ext = (h & 0x00000030) >> 4;
	head.copy = (h & 0x00000008) >> 3;
	head.orig = (h & 0x00000004) >> 2;
	head.emph = (h & 0x00000003) >> 0;

	if(head.id != 1){
		warn("ID must be 1");
		return -1;
	}
	if(head.rate == 0){
		warn("free bitrate format NIY");
		return -1;	
	}
	if(head.rate == 15){
		//warn("rate is invalid");
		return -1;
	}
	if(head.freq == 3){
		warn("frequency is invalid");
		return -1;
	}
	if(head.layer == 0){
		warn("layer 0 is invalid");
		return -1;
	}
	head.layer = 4 - head.layer;

	return 0;
}

static int
readcrc(void)
{
	uint b1, b2;

	b1 = getbyte();
	b2 = getbyte();
	if((b1 == EOF) || (b2 == EOF))
		return 0;
	return 0;
}

static uint
getinfobits(uint n)
{
	uint tmp;

	tmp = (infoptr[0]<<24) | (infoptr[1]<<16) | (infoptr[2]<<8) | (infoptr[3]<<0);
	tmp = tmp << infoidx;
	tmp = tmp >> (32-n);
	infoptr += (infoidx+n) >> 3;
	infoidx = (infoidx+n) & 0x07;

	return tmp;
}

static void
readaudio(void)
{
	uint isize, nch, ch, gr, scfsi, reg, win;

	nch = (head.mode == Singlechan ? 1 : 2);
	isize = (nch == 1 ? 17 : 32);
	getinfo(isize);

	info.begin = getinfobits(9);
	if(head.mode == Singlechan)
		info.priv = getinfobits(5);
	else
		info.priv = getinfobits(3);

	for(ch = 0; ch < nch; ch++){
		for(scfsi = 0; scfsi < 4; scfsi++)
			info.scfsi[ch][scfsi] = getinfobits(1);
	}

	for(gr = 0; gr < 2; gr++){
		for(ch = 0; ch < nch; ch++){
			info.len[gr][ch] = getinfobits(12);
			info.big[gr][ch] = getinfobits(9);
			info.gain[gr][ch] = getinfobits(8);
			info.com[gr][ch] = getinfobits(4);
			info.swtch[gr][ch] = getinfobits(1);

			if(info.swtch[gr][ch] == 1){
				info.block[gr][ch] = getinfobits(2);
				info.mblk[gr][ch] = getinfobits(1);
				for(reg = 0; reg < 2; reg++)
					info.tblsel[gr][ch][reg] = getinfobits(5);
				for(win = 0; win < 3; win++)
					info.sblk[gr][ch][win] = getinfobits(3);
				if((info.block[gr][ch] == 2) && (info.mblk[gr][ch] == 0))
					info.reg0[gr][ch] = 8;
				else
					info.reg0[gr][ch] = 7;
				info.reg1[gr][ch] = 20 - info.reg0[gr][ch];
			}else{
				for(reg = 0; reg < 3; reg++)
					info.tblsel[gr][ch][reg] = getinfobits(5);
				info.reg0[gr][ch] = getinfobits(4);
				info.reg1[gr][ch] = getinfobits(3);
				info.block[gr][ch] = 0;
			}

			info.pflag[gr][ch] = getinfobits(1);
			info.scale[gr][ch] = getinfobits(1);
			info.sel[gr][ch] = getinfobits(1);
		}
	}
}

static int
readmain(void)
{
	uint size, isize, dsize;
	uint gr, ch, nch, sfb, win, slen1, slen2, nbits, part2;

	nch = (head.mode == Singlechan ? 1 : 2);
	size = (144*rates[head.layer - 1][head.rate]) / freq[head.freq]+head.pad;

	if(size > 2000)
		return -1;
	isize = (nch == 1 ? 17 : 32);
	dsize = size - isize - 4;
	if(head.pro == 0)
		dsize -= 2;
	if(getmaindata(dsize, info.begin) != 0)
		return -1;

	for(gr = 0; gr < 2; gr++){
		for(ch = 0; ch < nch; ch++){
			part2 = getmainpos();
			slen1 = sfsizes[info.com[gr][ch]][0];
			slen2 = sfsizes[info.com[gr][ch]][1];

			if((info.swtch[gr][ch] != 0) && (info.block[gr][ch] == 2)){
				if(info.mblk[gr][ch] != 0){
					for(sfb = 0; sfb < 8; sfb++)
						data.sfl[gr][ch][sfb] = getmainbits(slen1);
					for(sfb = 3; sfb < 12; sfb++){
						if(sfb < 6)
							nbits = slen1;
						else
							nbits = slen2;
						for(win = 0; win < 3; win++)
							data.sfs[gr][ch][sfb][win] = getmainbits(nbits);
					}
				}else{
					for(sfb = 0; sfb < 12; sfb++){
						if(sfb < 6)
							nbits = slen1;
						else
							nbits = slen2;
						for(win = 0; win < 3;win++)
							data.sfs[gr][ch][sfb][win] = getmainbits(nbits);
					}
				}
			}else{
				if((info.scfsi[ch][0] == 0) || (gr == 0)){
					for(sfb = 0; sfb < 6; sfb++)
						data.sfl[gr][ch][sfb] = getmainbits(slen1);
				}else if((info.scfsi[ch][0] == 1) && (gr == 1)){
					for(sfb = 0; sfb < 6; sfb++)
						data.sfl[1][ch][sfb] = data.sfl[0][ch][sfb];
				}
				if((info.scfsi[ch][1] == 0)|| (gr == 0)){
					for(sfb = 6; sfb < 11; sfb++)
						data.sfl[gr][ch][sfb] = getmainbits(slen1);
				}else if((info.scfsi[ch][1] == 1) && (gr == 1)){
					for(sfb = 6; sfb < 11; sfb++)
						data.sfl[1][ch][sfb] = data.sfl[0][ch][sfb];
				}
				if((info.scfsi[ch][2] == 0)|| (gr == 0)){
					for(sfb = 11; sfb < 16; sfb++)
						data.sfl[gr][ch][sfb] = getmainbits(slen2);
				}else if((info.scfsi[ch][2] == 1) && (gr == 1)){
					for(sfb = 11; sfb < 16; sfb++)
						data.sfl[1][ch][sfb] = data.sfl[0][ch][sfb];
				}
				if((info.scfsi[ch][3] == 0) || (gr == 0)){
					for(sfb = 16; sfb < 21; sfb++)
						data.sfl[gr][ch][sfb] = getmainbits(slen2);
				}else if((info.scfsi[ch][3] == 1) && (gr == 1)){
					for(sfb = 16; sfb < 21; sfb++)
						data.sfl[1][ch][sfb] = data.sfl[0][ch][sfb];
				}
			}
			readhuff(part2, gr, ch);
		}
	}
	return 0;
}

static int
readframe(void)
{
	uint first = 0;

	if(init == 0){
		init = 1;
		first = 1;
		datatop = 0;
	}
	if(readhead() != 0)
		return -1;
	if(first)
		initdecode();
	if(head.pro == 0){
		if(readcrc() != 0)
			return -1;
	}
	if(head.layer == 3){
		readaudio();
		if(readmain() != 0)
			return -1;
	}else{
		warn("only layer 3 is supported");
		return -1;
	}
	return 0;
}

uint
getmainbits(uint n)
{
	uint tmp;

	if(n == 0)
		return 0;

	tmp = (dataptr[0]<<24)|(dataptr[1]<<16)|(dataptr[2]<<8)|(dataptr[3]<<0);
	tmp = tmp << dataidx;
	tmp = tmp >> (32-n);
	dataptr += (dataidx+n) >> 3;
	dataidx = (dataidx+n) & 0x07;

	return tmp;
}

uint
getmainbit(void)
{
	uint tmp;

	tmp = dataptr[0] >> (7-dataidx);
	tmp &= 0x01;
	dataptr += (dataidx+1) >> 3;
	dataidx = (dataidx+1) & 0x07;

	return tmp;
}

int
setmainpos(uint bitpos)
{
	dataptr = &datavec[bitpos>>3];
	dataidx = bitpos & 0x7;

	return 0;
}

uint
getmainpos(void)
{
	uint pos;

	pos = ((uint) dataptr) - ((uint) &datavec[0]);
	pos /= 4;		
	pos = pos << 3;		
	pos = pos + dataidx;	

	return pos;
}

void
audiowrite(uint *sa, uint nsa)
{
	int i, nch;
	uint lo, hi;
	ushort s[576*2];

	nch = (head.mode == Singlechan ? 1 : 2);
	for(i = 0; i < nsa; i++){
		if(nch == 1){
			lo = sa[i] & 0xffff;
			s[i] = lo;
		}else{
			lo = sa[i] & 0xffff;
			hi = (sa[i] & 0xffff0000) >> 16;
			s[2*i] = hi;
			s[2*i+1] = lo;
		}
	}
	if(Bwrite(&bout, (char *) s, nsa*2*nch) != nsa*2*nch)
		sysfatal("unable to write raw data: %r");
}

static void
mp3dec(void)
{
	while(1){
		if(readframe() == 0)
			decode();
		else
			break;
	}
	Bterm(bin);
}

void
main(int argc, char *argv[])
{
	static int i;
	argv0 = "mp3dec";
	Binit(&bout, 1, OWRITE);

	if(argc == 1){
		bin = malloc(sizeof(Biobuf));
		if(bin == nil)
			sysfatal("out of memory: %r");
		Binit(bin, 0, OREAD);
		mp3dec();
	}else{
		for(i = 1; i < argc; i++){
			if((bin = Bopen(argv[i], OREAD)) == nil)
				sysfatal("can't open %s: %r", argv[i]);
			mp3dec();
		}
	}
	Bterm(&bout);
	exits(nil);
}
