#include <u.h>
#include <libc.h>
#include "mp3dec.h"

static uint hsynthinit = 1, synthinit = 1;
float synthtbl[512] = {
	0.000000000, -0.000015259, -0.000015259, -0.000015259,
	-0.000015259, -0.000015259, -0.000015259, -0.000030518,
	-0.000030518, -0.000030518, -0.000030518, -0.000045776,
	-0.000045776, -0.000061035, -0.000061035, -0.000076294,
	-0.000076294, -0.000091553, -0.000106812, -0.000106812,
	-0.000122070, -0.000137329, -0.000152588, -0.000167847,
	-0.000198364, -0.000213623, -0.000244141, -0.000259399,
	-0.000289917, -0.000320435, -0.000366211, -0.000396729,
	-0.000442505, -0.000473022, -0.000534058, -0.000579834,
	-0.000625610, -0.000686646, -0.000747681, -0.000808716,
	-0.000885010, -0.000961304, -0.001037598, -0.001113892,
	-0.001205444, -0.001296997, -0.001388550, -0.001480103,
	-0.001586914, -0.001693726, -0.001785278, -0.001907349,
	-0.002014160, -0.002120972, -0.002243042, -0.002349854,
	-0.002456665, -0.002578735, -0.002685547, -0.002792358,
	-0.002899170, -0.002990723, -0.003082275, -0.003173828,
	0.003250122, 0.003326416, 0.003387451, 0.003433228,
	0.003463745, 0.003479004, 0.003479004, 0.003463745,
	0.003417969, 0.003372192, 0.003280640, 0.003173828,
	0.003051758, 0.002883911, 0.002700806, 0.002487183,
	0.002227783, 0.001937866, 0.001617432, 0.001266479,
	0.000869751, 0.000442505, -0.000030518, -0.000549316,
	-0.001098633, -0.001693726, -0.002334595, -0.003005981,
	-0.003723145, -0.004486084, -0.005294800, -0.006118774,
	-0.007003784, -0.007919312, -0.008865356, -0.009841919,
	-0.010848999, -0.011886597, -0.012939453, -0.014022827,
	-0.015121460, -0.016235352, -0.017349243, -0.018463135,
	-0.019577026, -0.020690918, -0.021789551, -0.022857666,
	-0.023910522, -0.024932861, -0.025909424, -0.026840210,
	-0.027725220, -0.028533936, -0.029281616, -0.029937744,
	-0.030532837, -0.031005859, -0.031387329, -0.031661987,
	-0.031814575, -0.031845093, -0.031738281, -0.031478882,
	0.031082153, 0.030517578, 0.029785156, 0.028884888,
	0.027801514, 0.026535034, 0.025085449, 0.023422241,
	0.021575928, 0.019531250, 0.017257690, 0.014801025,
	0.012115479, 0.009231567, 0.006134033, 0.002822876,
	-0.000686646, -0.004394531, -0.008316040, -0.012420654,
	-0.016708374, -0.021179199, -0.025817871, -0.030609131,
	-0.035552979, -0.040634155, -0.045837402, -0.051132202,
	-0.056533813, -0.061996460, -0.067520142, -0.073059082,
	-0.078628540, -0.084182739, -0.089706421, -0.095169067,
	-0.100540161, -0.105819702, -0.110946655, -0.115921021,
	-0.120697021, -0.125259399, -0.129562378, -0.133590698,
	-0.137298584, -0.140670776, -0.143676758, -0.146255493,
	-0.148422241, -0.150115967, -0.151306152, -0.151962280,
	-0.152069092, -0.151596069, -0.150497437, -0.148773193,
	-0.146362305, -0.143264771, -0.139450073, -0.134887695,
	-0.129577637, -0.123474121, -0.116577148, -0.108856201,
	0.100311279, 0.090927124, 0.080688477, 0.069595337,
	0.057617188, 0.044784546, 0.031082153, 0.016510010,
	0.001068115, -0.015228271, -0.032379150, -0.050354004,
	-0.069168091, -0.088775635, -0.109161377, -0.130310059,
	-0.152206421, -0.174789429, -0.198059082, -0.221984863,
	-0.246505737, -0.271591187, -0.297210693, -0.323318481,
	-0.349868774, -0.376800537, -0.404083252, -0.431655884,
	-0.459472656, -0.487472534, -0.515609741, -0.543823242,
	-0.572036743, -0.600219727, -0.628295898, -0.656219482,
	-0.683914185, -0.711318970, -0.738372803, -0.765029907,
	-0.791213989, -0.816864014, -0.841949463, -0.866363525,
	-0.890090942, -0.913055420, -0.935195923, -0.956481934,
	-0.976852417, -0.996246338, -1.014617920, -1.031936646,
	-1.048156738, -1.063217163, -1.077117920, -1.089782715,
	-1.101211548, -1.111373901, -1.120223999, -1.127746582,
	-1.133926392, -1.138763428, -1.142211914, -1.144287109,
	1.144989014, 1.144287109, 1.142211914, 1.138763428,
	1.133926392, 1.127746582, 1.120223999, 1.111373901,
	1.101211548, 1.089782715, 1.077117920, 1.063217163,
	1.048156738, 1.031936646, 1.014617920, 0.996246338,
	0.976852417, 0.956481934, 0.935195923, 0.913055420,
	0.890090942, 0.866363525, 0.841949463, 0.816864014,
	0.791213989, 0.765029907, 0.738372803, 0.711318970,
	0.683914185, 0.656219482, 0.628295898, 0.600219727,
	0.572036743, 0.543823242, 0.515609741, 0.487472534,
	0.459472656, 0.431655884, 0.404083252, 0.376800537,
	0.349868774, 0.323318481, 0.297210693, 0.271591187,
	0.246505737, 0.221984863, 0.198059082, 0.174789429,
	0.152206421, 0.130310059, 0.109161377, 0.088775635,
	0.069168091, 0.050354004, 0.032379150, 0.015228271,
	-0.001068115, -0.016510010, -0.031082153, -0.044784546,
	-0.057617188, -0.069595337, -0.080688477, -0.090927124,
	0.100311279, 0.108856201, 0.116577148, 0.123474121,
	0.129577637, 0.134887695, 0.139450073, 0.143264771,
	0.146362305, 0.148773193, 0.150497437, 0.151596069,
	0.152069092, 0.151962280, 0.151306152, 0.150115967,
	0.148422241, 0.146255493, 0.143676758, 0.140670776,
	0.137298584, 0.133590698, 0.129562378, 0.125259399,
	0.120697021, 0.115921021, 0.110946655, 0.105819702,
	0.100540161, 0.095169067, 0.089706421, 0.084182739,
	0.078628540, 0.073059082, 0.067520142, 0.061996460,
	0.056533813, 0.051132202, 0.045837402, 0.040634155,
	0.035552979, 0.030609131, 0.025817871, 0.021179199,
	0.016708374, 0.012420654, 0.008316040, 0.004394531,
	0.000686646, -0.002822876, -0.006134033, -0.009231567,
	-0.012115479, -0.014801025, -0.017257690, -0.019531250,
	-0.021575928, -0.023422241, -0.025085449, -0.026535034,
	-0.027801514, -0.028884888, -0.029785156, -0.030517578,
	0.031082153, 0.031478882, 0.031738281, 0.031845093,
	0.031814575, 0.031661987, 0.031387329, 0.031005859,
	0.030532837, 0.029937744, 0.029281616, 0.028533936,
	0.027725220, 0.026840210, 0.025909424, 0.024932861,
	0.023910522, 0.022857666, 0.021789551, 0.020690918,
	0.019577026, 0.018463135, 0.017349243, 0.016235352,
	0.015121460, 0.014022827, 0.012939453, 0.011886597,
	0.010848999, 0.009841919, 0.008865356, 0.007919312,
	0.007003784, 0.006118774, 0.005294800, 0.004486084,
	0.003723145, 0.003005981, 0.002334595, 0.001693726,
	0.001098633, 0.000549316, 0.000030518, -0.000442505,
	-0.000869751, -0.001266479, -0.001617432, -0.001937866,
	-0.002227783, -0.002487183, -0.002700806, -0.002883911,
	-0.003051758, -0.003173828, -0.003280640, -0.003372192,
	-0.003417969, -0.003463745, -0.003479004, -0.003479004,
	-0.003463745, -0.003433228, -0.003387451, -0.003326416,
	0.003250122, 0.003173828, 0.003082275, 0.002990723,
	0.002899170, 0.002792358, 0.002685547, 0.002578735,
	0.002456665, 0.002349854, 0.002243042, 0.002120972,
	0.002014160, 0.001907349, 0.001785278, 0.001693726,
	0.001586914, 0.001480103, 0.001388550, 0.001296997,
	0.001205444, 0.001113892, 0.001037598, 0.000961304,
	0.000885010, 0.000808716, 0.000747681, 0.000686646,
	0.000625610, 0.000579834, 0.000534058, 0.000473022,
	0.000442505, 0.000396729, 0.000366211, 0.000320435,
	0.000289917, 0.000259399, 0.000244141, 0.000213623,
	0.000198364, 0.000167847, 0.000152588, 0.000137329,
	0.000122070, 0.000106812, 0.000106812, 0.000091553,
	0.000076294, 0.000076294, 0.000061035, 0.000061035,
	0.000045776, 0.000045776, 0.000030518, 0.000030518,
	0.000030518, 0.000030518, 0.000015259, 0.000015259,
	0.000015259, 0.000015259, 0.000015259, 0.000015259,
};

static void
pow43(uint gr, uint ch, uint i, uint sfb)
{
	float tmp1, tmp2, tmp3, sfmult, pfxpt;
	static float pretab[21] = { 
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		1, 1, 1, 1, 2, 2, 3, 3, 3, 2
	};

	sfmult = info.scale[gr][ch] ? 1.0 : 0.5;
	pfxpt = info.pflag[gr][ch]*pretab[sfb];
	tmp1 = pow(2.0, -(sfmult*(data.sfl[gr][ch][sfb]+pfxpt)));
	tmp2 = pow(2.0, 0.25*((int) info.gain[gr][ch]-210));

	if(data.is[gr][ch][i] < 0.0){
		tmp3 = pow(-data.is[gr][ch][i], 4.0/3.0);
		tmp3 = -tmp3;
	}else
		tmp3 = pow(data.is[gr][ch][i], 4.0/3.0);

	data.is[gr][ch][i] = tmp1*tmp2*tmp3;
}

static void
requantize(uint gr, uint ch)
{
	uint sfb, nsfb;
	uint sfreq, i, j, win, winlen;
	sfreq = head.freq;

	if((info.swtch[gr][ch] == 1) && (info.block[gr][ch] == 2)){
		if(info.mblk[gr][ch] != 0){	
			sfb = 0;
			nsfb = idcs[sfreq].l[sfb+1];

			for(i = 0; i < 36; i++){
				if(i == nsfb){
					sfb++;
					nsfb = idcs[sfreq].l[sfb+1];
				}
				pow43(gr, ch, i, sfb);
			}

			sfb = 3;
			nsfb = idcs[sfreq].s[sfb+1] * 3;
			winlen = idcs[sfreq].s[sfb+1] - idcs[sfreq].s[sfb];
			for(i = 36; i < info.cnt[gr][ch];){
				if(i == nsfb){	
					sfb++;
					nsfb = idcs[sfreq].s[sfb+1]*3;
					winlen = idcs[sfreq].s[sfb+1] - idcs[sfreq].s[sfb];
				}
				for(win = 0; win < 3; win++){
					for(j = 0; j < winlen; j++){
						pow43(gr, ch, i, sfb);
						i++;
					}
				}
			}
		}else{
			sfb = 0;
			nsfb = idcs[sfreq].s[sfb+1] * 3;
			winlen = idcs[sfreq].s[sfb+1] - idcs[sfreq].s[sfb];

			for(i = 0; i < info.cnt[gr][ch];){
				if(i == nsfb){	
					sfb++;
					nsfb = idcs[sfreq].s[sfb+1] * 3;
					winlen = idcs[sfreq].s[sfb+1] - idcs[sfreq].s[sfb];
				}
				for(win = 0; win < 3; win++){
					for(j = 0; j < winlen; j++){
						pow43(gr, ch, i, sfb);
						i++;
					}
				}
			}
		}
	}else{		
		sfb = 0;
		nsfb = idcs[sfreq].l[sfb+1];
		for(i = 0; i < info.cnt[gr][ch]; i++){
			if(i == nsfb){
				sfb++;
				nsfb = idcs[sfreq].l[sfb+1];
			}
			pow43(gr, ch, i, sfb);
		}
	}
}

static void
reorder(uint gr, uint ch)
{
	uint sfreq, i, j, nsfb, sfb, winlen, win;
	float re[576];

	sfreq = head.freq;
	if((info.swtch[gr][ch] == 1) && (info.block[gr][ch] == 2)){
		if(info.mblk[gr][ch] != 0){
			sfb = 3;
			nsfb = idcs[sfreq].s[sfb+1] * 3;
			winlen = idcs[sfreq].s[sfb+1] - idcs[sfreq].s[sfb];
		}else{
			sfb = 0;
			nsfb = idcs[sfreq].s[sfb+1] * 3;
			winlen = idcs[sfreq].s[sfb+1] - idcs[sfreq].s[sfb];
		}
		for(i = ((sfb == 0) ? 0 : 36); i < 576;){
			if(i == nsfb){
				for(j = 0; j < 3 * winlen; j++)
					data.is[gr][ch][3*idcs[sfreq].s[sfb]+j] = re[j];
				if(i >= info.cnt[gr][ch])	
					return;
				sfb++;
				nsfb = idcs[sfreq].s[sfb+1] * 3;
				winlen = idcs[sfreq].s[sfb+1] - idcs[sfreq].s[sfb];
			}
			for(win = 0; win < 3; win++){
				for(j = 0; j < winlen; j++){
					re[j*3+win] = data.is[gr][ch][i];
					i++;
				}
			}
		}
		for(j = 0; j < 3 * winlen; j++)
			data.is[gr][ch][3*idcs[sfreq].s[12]+j] = re[j];
	}
}

static void
intensitylong(uint gr, uint sfb)
{
	static int init = 0;
	static float isratios[6];
	uint i;
	uint sfreq, sfbstart, sfbstop, ispos;
	float isratiol, isratior;
	float left, right;

	if(init == 0){
		init = 1;
		for(i = 0; i < 6; i++)
			isratios[i] = tan((i*PI)/12.0);
	}

	if((ispos = data.sfl[gr][0][sfb]) != 7){
		sfreq = head.freq;
		sfbstart = idcs[sfreq].l[sfb];
		sfbstop = idcs[sfreq].l[sfb+1];

		if(ispos == 6){
			isratiol = 1.0;
			isratior = 0.0;
		}else{
			isratiol = isratios[ispos] / (1.0 + isratios[ispos]);
			isratior = 1.0 / (1.0+isratios[ispos]);
		}

		for(i = sfbstart; i < sfbstop; i++){
			left = isratiol * data.is[gr][0][i];
			right = isratior * data.is[gr][0][i];
			data.is[gr][0][i] = left;
			data.is[gr][1][i] = right;
		}
	}
}

static void
intensityshort(uint gr, uint sfb)
{
	uint i;
	float left, right;
	uint sfbstart, sfbstop;
	uint sfreq, win, winlen;
	
	sfreq = head.freq;
	winlen = idcs[sfreq].s[sfb+1] - idcs[sfreq].s[sfb];

	for(win = 0; win < 3; win++){
		if(data.sfs[gr][0][sfb][win] != 7){
			sfbstart = idcs[sfreq].s[sfb] * 3 + winlen * win;
			sfbstop = sfbstart + winlen;
			for(i = sfbstart; i < sfbstop; i++){
				left = data.is[gr][0][i];
				right = data.is[gr][0][i];
				data.is[gr][0][i] = left;
				data.is[gr][1][i] = right;
			}
		}
	}
}

#define INVSQRT2 0.70710678118654752440
static void
stereo(uint gr)
{
	uint maxpos, i;
	float left, right;
	uint sfb  ;
	uint sfreq;

	if((head.mode != 1) || (head.ext == 0))
		return;

	if(head.ext & 0x2){
		if(info.cnt[gr][0] > info.cnt[gr][1])
			maxpos = info.cnt[gr][0];
		else
			maxpos = info.cnt[gr][1];

		for(i = 0; i < maxpos; i++){
			left = (data.is[gr][0][i] + data.is[gr][1][i]) * (INVSQRT2);
			right = (data.is[gr][0][i] - data.is[gr][1][i]) * (INVSQRT2);
			data.is[gr][0][i] = left;
			data.is[gr][1][i] = right;
		}
	}

	if(head.ext & 0x1){
		sfreq = head.freq;
		if((info.swtch[gr][0] == 1) && (info.block[gr][0] == 2)){
			if(info.mblk[gr][0] != 0){	
				for(sfb = 0; sfb < 8; sfb++){
					if(idcs[sfreq].l[sfb] >= info.cnt[gr][1])
						intensitylong(gr, sfb);
				}
				for(sfb = 3; sfb < 12; sfb++){
					if(idcs[sfreq].s[sfb] * 3 >= info.cnt[gr][1])
						intensityshort(gr, sfb);
				}
			}else{
				for(sfb = 0; sfb < 12; sfb++){	
					if(idcs[sfreq].s[sfb] * 3 >= info.cnt[gr][1])	
						intensityshort(gr, sfb);
				}
			}
		}else{	
			for(sfb = 0; sfb < 21; sfb++){		
				if(idcs[sfreq].l[sfb] >= info.cnt[gr][1])		
					intensitylong(gr, sfb);
			}
		}
	}
}

static void
antialias(uint gr, uint ch)
{
	uint sb, i, sblim, ui, li;
	static uint init = 1;
	float ub, lb;
	static float cs[8], ca[8];
	static float ci[8] = { 
		-0.6, -0.535, -0.33, -0.185, -0.095, -0.041, -0.0142, -0.0037
	};
	
	if(init){
		for(i = 0; i < 8; i++){
			cs[i] = 1.0 / sqrt(1.0 + ci[i] * ci[i]);
			ca[i] = ci[i] / sqrt(1.0 + ci[i] * ci[i]);
		}
		init = 0;
	}

	if((info.swtch[gr][ch] == 1) && (info.block[gr][ch] == 2) && (info.mblk[gr][ch]) == 0)	
		return;

	if((info.swtch[gr][ch] == 1) && (info.block[gr][ch] == 2) && (info.mblk[gr][ch]) == 1)
		sblim = 2;
	else
		sblim = 32;

	for(sb = 1; sb < sblim; sb++){
		for(i = 0; i < 8; i++){
			li = 18 * sb - 1 - i;
			ui = 18 * sb + i;
			lb = data.is[gr][ch][li] * cs[i] - data.is[gr][ch][ui] * ca[i];
			ub = data.is[gr][ch][ui] * cs[i] + data.is[gr][ch][li] * ca[i];
			data.is[gr][ch][li] = lb;
			data.is[gr][ch][ui] = ub;
		}
	}
}

static void
imdctwin(float in[18], float out[36], uint block)
{
	static float imdct[4][36];
	uint i, m, N, p;
	float tmp[12], sum;
	float tin[18];
	static uint init = 1;

	if(init){	
		for(i = 0; i < 36; i++)
			imdct[0][i] = sin(PI / 36 * (i + 0.5));
		for(i = 0; i < 18; i++)
			imdct[1][i] = sin(PI / 36 * (i + 0.5));
		for(i = 18; i < 24; i++)
			imdct[1][i] = 1.0;
		for(i = 24; i < 30; i++)
			imdct[1][i] = sin(PI / 12 * (i + 0.5 - 18.0));
		for(i = 30; i < 36; i++)
			imdct[1][i] = 0.0;
		for(i = 0; i < 12; i++)
			imdct[2][i] = sin(PI / 12 * (i + 0.5));
		for(i = 12; i < 36; i++)
			imdct[2][i] = 0.0;
		for(i = 0; i < 6; i++)
			imdct[3][i] = 0.0;
		for(i = 6; i < 12; i++)
			imdct[3][i] = sin(PI / 12 * (i + 0.5 - 6.0));
		for(i = 12; i < 18; i++)
			imdct[3][i] = 1.0;
		for(i = 18; i < 36; i++)
			imdct[3][i] = sin(PI / 36 * (i + 0.5));
		init = 0;
	}
	
	for(i = 0; i < 36; i++)
		out[i] = 0.0;
	for(i = 0; i < 18; i++)
		tin[i] = in[i];

	if(block == 2){
		N = 12;
		for(i = 0; i < 3; i++){
			for(p = 0; p < N; p++){
				sum = 0.0;
				for(m = 0; m < N/2; m++)
					sum += tin[i+3*m] * cos(PI/(2*N) * (2*p+1+N/2) * (2*m+1));
				tmp[p] = sum * imdct[block][p];
			}
			for(p = 0; p < N; p++)
				out[6*i+p+6] += tmp[p];
		}
	}else{	
		N = 36;
		for(p = 0; p < N; p++){
			sum = 0.0;
			for(m = 0; m < N / 2; m++)
				sum += in[m] * cos(PI/(2*N) * (2*p+1+N/2) * (2*m+1));
			out[p] = sum * imdct[block][p];
		}
	}
}

static void
synthesis(uint gr, uint ch)
{
	uint sb, i, j, bt;
	float rawout[36];
	static float store[2][32][18];

	if(hsynthinit){	
		for(j = 0; j < 2; j++){
			for(sb = 0; sb < 32; sb++){
				for(i = 0; i < 18; i++)
					store[j][sb][i] = 0.0;
			}
		}
		hsynthinit = 0;
	}

	for(sb = 0; sb < 32; sb++){
		if((info.swtch[gr][ch] == 1) && 
			(info.mblk[gr][ch] == 1) && (sb < 2))
			bt = 0;	
		else
			bt = info.block[gr][ch];

		imdctwin(&data.is[gr][ch][sb*18], rawout, bt);

		for(i = 0; i < 18; i++){
			data.is[gr][ch][sb*18+i] = rawout[i] + store[ch][sb][i];
			store[ch][sb][i] = rawout[i+18];
		}
	}
}

static void
freqinversion(uint gr, uint ch)
{
	uint sb, i;

	for(sb = 1; sb < 32; sb += 2){
		for(i = 1; i < 18; i += 2)
			data.is[gr][ch][sb*18+i] = -data.is[gr][ch][sb*18+i];
	}
}

static void
subsynth(uint gr, uint ch, uint outdata[576])
{
	float u_vec[512];
	float s_vec[32], sum;	
	int samp;
	static uint init = 1;
	uint ss, i, j, nch;
	static float synwin[64][32];
	static float v_vec[2][1024];

	nch = (head.mode == Singlechan ? 1 : 2);
	if(init){
		for(i = 0; i < 64; i++){
			for(j = 0; j < 32; j++)
				synwin[i][j] = cos(((float) (16+i)*(2*j+1))*(PI/64.0));
		}
		for(i = 0; i < 2; i++){
			for(j = 0; j < 1024; j++)
				v_vec[i][j] = 0.0;
		}
		init = 0;
	}
	
	if(synthinit){
		for(i = 0; i < 2; i++){
			for(j = 0; j < 1024; j++)
				v_vec[i][j] = 0.0;
		}
		synthinit = 0;
	}

	for(ss = 0; ss < 18; ss++){
		for(i = 1023; i > 63; i--)
			v_vec[ch][i] = v_vec[ch][i-64];
		for(i = 0; i < 32; i++)
			s_vec[i] = ((float) data.is[gr][ch][i*18+ss]);
		for(i = 0; i < 64; i++){
			sum = 0.0;
			for(j = 0; j < 32; j++)
				sum += synwin[i][j] * s_vec[j];
			v_vec[ch][i] = sum;
		}	

		for(i = 0; i < 8; i++){
			for(j = 0; j < 32; j++){
				u_vec[(i<<6)+j] = v_vec[ch][(i<<7)+j];
				u_vec[(i<<6)+j+32] = v_vec[ch][(i<<7)+j+96];
			}
		}	

		for(i = 0; i < 512; i++)
			u_vec[i] = u_vec[i] * synthtbl[i];
		for(i = 0; i < 32; i++){
			sum = 0.0;
			for(j = 0; j < 16; j++)
				sum += u_vec[(j<<5)+i];

			samp = (int) (sum * 32767.0);
			if(samp > 32767)
				samp = 32767;
			else if(samp < -32767)
				samp = -32767;

			samp &= 0xffff;
			if(ch == 0){
				if(nch == 1)
					outdata[32*ss+i] = (samp << 16) | (samp);
				else
					outdata[32*ss+i] = samp << 16;
			}else
				outdata[32*ss+i] |= samp;
		}
	}
}

void
initdecode(void)
{
	hsynthinit = 1;
	synthinit = 1;
	datatop = 0;
}

int
decode(void)
{
	uint gr, ch, nch;
	uint out[576];
	nch = (head.mode == Singlechan ? 1 : 2);

	for(gr = 0; gr < 2; gr++){
		for(ch = 0; ch < nch; ch++){
			requantize(gr, ch);
			reorder(gr, ch);
		}
		stereo(gr);
		for(ch = 0; ch < nch; ch++){
			antialias(gr, ch);
			synthesis(gr, ch);
			freqinversion(gr, ch);
			subsynth(gr, ch, out);
		}
		audiowrite((uint *) out, 576);
	}
	return 0;
}
