This is the change for for CWEB's CWEAVE under Plan9.
(by Lee Duhem, lee.duhem@gmail.com, February 2007)

@x
@ We predeclare several standard system functions here instead of including
their system header files, because the names of the header files are not as
standard as the names of the functions. (For example, some \CEE/ environments
have \.{<string.h>} where others have \.{<strings.h>}.)

@<Predecl...@>=
extern int strlen(); /* length of string */
extern int strcmp(); /* compare strings lexicographically */
extern char* strcpy(); /* copy one string to another */
extern int strncmp(); /* compare up to $n$ string characters */
extern char* strncpy(); /* copy up to $n$ string characters */
@y
@z

@x
int main (ac, av)
int ac; /* argument count */
char **av; /* argument values */
@y
void main (ac, av)
int ac; /* argument count */
char **av; /* argument values */
@z

@x
  return wrap_up(); /* and exit gracefully */
@y
  int e = wrap_up(); 
  if(e==0){exits(nil);}else{exits("1");}
@z

@x
@i common.h
@y
@i common-plan9.h
@z

@x
@<Predec...@>=
void   skip_limbo();
@y
@<Predec...@>=
void   skip_limbo(void);
@z

@x
@ @<Include...@>=
#include <ctype.h> /* definition of |isalpha|, |isdigit| and so on */
#include <stdlib.h> /* definition of |exit| */
@y
@ @<Include...@>=
#include <ctype.h> /* definition of |isalpha|, |isdigit| and so on */
@z

@x
@<Predecl...@>=
eight_bits get_next();
@y
@<Predecl...@>=
eight_bits get_next(void);
@z

@x
@<Predecl...@>=
void skip_restricted();
@y
@<Predecl...@>=
void skip_restricted(void);
@z

@x
@<Predecl...@>=
void phase_one();
@y
@<Predecl...@>=
void phase_one(void);
@z

@x
@<Predecl...@>=
void C_xref();

@ @c
void
C_xref( spec_ctrl ) /* makes cross-references for \CEE/ identifiers */
  eight_bits spec_ctrl;
@y
@<Predecl...@>=
void C_xref(eight_bits spec_ctrl);

@ @c
void
C_xref(eight_bits spec_ctrl) /* makes cross-references for \CEE/ identifiers */
@z

@x
@<Predecl...@>=
void outer_xref();
@y
@<Predecl...@>=
void outer_xref(void);
@z

@x
@<Predecl...@>=
void section_check();
@y
@<Predecl...@>=
void section_check(name_pointer p);
@z

@x
@c
void
flush_buffer(b,per_cent,carryover)
char *b;  /* outputs from |out_buf+1| to |b|,where |b<=out_ptr| */
boolean per_cent,carryover;
@y
@c
void
flush_buffer(char *b, boolean per_cent, boolean carryover)
@z

@x
@<Predecl...@>=
void break_out();
@y
@<Predecl...@>=
void break_out(void);
@z

@x
@ Here is a macro that outputs a section number in decimal notation.
The number to be converted by |out_section| is known to be less than
|def_flag|, so it cannot have more than five decimal digits.  If
the section is changed, we output `\.{\\*}' just after the number.

@c
void
out_section(n)
sixteen_bits n;
@y
@ Here is a macro that outputs a section number in decimal notation.
The number to be converted by |out_section| is known to be less than
|def_flag|, so it cannot have more than five decimal digits.  If
the section is changed, we output `\.{\\*}' just after the number.

@c
void
out_section(sixteen_bits n)
@z

@x
@ The |out_name| procedure is used to output an identifier or index
entry, enclosing it in braces.

@c
void
out_name(p,quote_xalpha)
name_pointer p;
boolean quote_xalpha;
@y
@ The |out_name| procedure is used to output an identifier or index
entry, enclosing it in braces.

@c
void
out_name(name_pointer p, boolean quote_xalpha)
@z

@x
@<Predec...@>=
int copy_comment();

@ @c
int copy_comment(is_long_comment,bal) /* copies \TEX/ code in comments */
boolean is_long_comment; /* is this a traditional \CEE/ comment? */
int bal; /* brace balance */
@y
@<Predec...@>=
int copy_comment(boolean is_long_comment, int bal);

@ @c
int copy_comment(boolean is_long_comment, int bal) /* copies \TEX/ code in comments */
@z

@x
@c
void
print_cat(c) /* symbolic printout of a category */
eight_bits c;
@y
@c
void
print_cat(eight_bits c) /* symbolic printout of a category */
@z

@x
@ @c
void
app_str(s)
char *s;
{
  while (*s) app_tok(*(s++));
}

void
big_app(a)
token a;
@y
@ @c
void
app_str(s)
char *s;
{
  while (*s) app_tok(*(s++));
}

void
big_app(token a)
@z

@x
@<Predecl...@>=
void  underline_xref();
@y
@<Predecl...@>=
void  underline_xref(name_pointer p);
@z

@x
@c
void
reduce(j,k,c,d,n)
scrap_pointer j;
eight_bits c;
short k, d, n;
@y
@c
void
reduce(scrap_pointer j, short k, eight_bits c, short d, short n)
@z

@x
@ Here's the |squash| procedure, which
takes advantage of the simplification that occurs when |k==1|.

@c
void
squash(j,k,c,d,n)
scrap_pointer j;
eight_bits c;
short k, d, n;
@y
@ Here's the |squash| procedure, which
takes advantage of the simplification that occurs when |k==1|.

@c
void
squash(scrap_pointer j, short k, eight_bits c, short d, short n)
@z

@x
C_parse(spec_ctrl) /* creates scraps from \CEE/ tokens */
  eight_bits spec_ctrl;
@y
C_parse(eight_bits spec_ctrl) /* creates scraps from \CEE/ tokens */
@z

@x
@<Predec...@>=
void app_cur_id();

@ @c
void
app_cur_id(scrapping)
boolean scrapping; /* are we making this into a scrap? */
@y
@<Predec...@>=
void app_cur_id(boolean scrapping);

@ @c
void
app_cur_id(boolean scrapping)
@z

@x
@<Predecl...@>=
void make_output();
@y
@<Predecl...@>=
void make_output(void);
@z

@x
@<Predecl...@>=
void phase_two();
@y
@<Predecl...@>=
void phase_two(void);
@z

@x
@<Predecl...@>=
void finish_C();

@ @c
void
finish_C(visible) /* finishes a definition or a \CEE/ part */
  boolean visible; /* nonzero if we should produce \TEX/ output */
@y
@<Predecl...@>=
void finish_C(boolean visible);

@ @c
void
finish_C(boolean visible) /* finishes a definition or a \CEE/ part */
@z

@x
@<Predecl...@>=
void footnote();

@ @c
void
footnote(flag) /* outputs section cross-references */
sixteen_bits flag;
@y
@<Predecl...@>=
void footnote(sixteen_bits flag);

@ @c
void
footnote(sixteen_bits flag) /* outputs section cross-references */
@z

@x
@<Predecl...@>=
void phase_three();
@y
@<Predecl...@>=
void phase_three(void);
@z

@x
@<Set init...@>=
collate[0]=0;
strcpy(collate+1," \1\2\3\4\5\6\7\10\11\12\13\14\15\16\17");
/* 16 characters + 1 = 17 */
strcpy(collate+17,"\20\21\22\23\24\25\26\27\30\31\32\33\34\35\36\37");
/* 16 characters + 17 = 33 */
strcpy(collate+33,"!\42#$%&'()*+,-./:;<=>?@@[\\]^`{|}~_");
/* 32 characters + 33 = 65 */
strcpy(collate+65,"abcdefghijklmnopqrstuvwxyz0123456789");
/* (26 + 10) characters + 65 = 101 */
strcpy(collate+101,"\200\201\202\203\204\205\206\207\210\211\212\213\214\215\216\217");
/* 16 characters + 101 = 117 */
strcpy(collate+117,"\220\221\222\223\224\225\226\227\230\231\232\233\234\235\236\237");
/* 16 characters + 117 = 133 */
strcpy(collate+133,"\240\241\242\243\244\245\246\247\250\251\252\253\254\255\256\257");
/* 16 characters + 133 = 149 */
strcpy(collate+149,"\260\261\262\263\264\265\266\267\270\271\272\273\274\275\276\277");
/* 16 characters + 149 = 165 */
strcpy(collate+165,"\300\301\302\303\304\305\306\307\310\311\312\313\314\315\316\317");
/* 16 characters + 165 = 181 */
strcpy(collate+181,"\320\321\322\323\324\325\326\327\330\331\332\333\334\335\336\337");
/* 16 characters + 181 = 197 */
strcpy(collate+197,"\340\341\342\343\344\345\346\347\350\351\352\353\354\355\356\357");
/* 16 characters + 197 = 213 */
strcpy(collate+213,"\360\361\362\363\364\365\366\367\370\371\372\373\374\375\376\377");
/* 16 characters + 213 = 229 */
@y
@<Set init...@>=
collate[0]=0;
strcpy((char *)collate+1," \1\2\3\4\5\6\7\10\11\12\13\14\15\16\17");
/* 16 characters + 1 = 17 */
strcpy((char *)collate+17,"\20\21\22\23\24\25\26\27\30\31\32\33\34\35\36\37");
/* 16 characters + 17 = 33 */
strcpy((char *)collate+33,"!\42#$%&'()*+,-./:;<=>?@@[\\]^`{|}~_");
/* 32 characters + 33 = 65 */
strcpy((char *)collate+65,"abcdefghijklmnopqrstuvwxyz0123456789");
/* (26 + 10) characters + 65 = 101 */
strcpy((char *)collate+101,"\200\201\202\203\204\205\206\207\210\211\212\213\214\215\216\217");
/* 16 characters + 101 = 117 */
strcpy((char *)collate+117,"\220\221\222\223\224\225\226\227\230\231\232\233\234\235\236\237");
/* 16 characters + 117 = 133 */
strcpy((char *)collate+133,"\240\241\242\243\244\245\246\247\250\251\252\253\254\255\256\257");
/* 16 characters + 133 = 149 */
strcpy((char *)collate+149,"\260\261\262\263\264\265\266\267\270\271\272\273\274\275\276\277");
/* 16 characters + 149 = 165 */
strcpy((char *)collate+165,"\300\301\302\303\304\305\306\307\310\311\312\313\314\315\316\317");
/* 16 characters + 165 = 181 */
strcpy((char *)collate+181,"\320\321\322\323\324\325\326\327\330\331\332\333\334\335\336\337");
/* 16 characters + 181 = 197 */
strcpy((char *)collate+197,"\340\341\342\343\344\345\346\347\350\351\352\353\354\355\356\357");
/* 16 characters + 197 = 213 */
strcpy((char *)collate+213,"\360\361\362\363\364\365\366\367\370\371\372\373\374\375\376\377");
/* 16 characters + 213 = 229 */
@z

@x
@<Predecl...@>=
void  unbucket();

@ @c
void
unbucket(d) /* empties buckets having depth |d| */
eight_bits d;
@y
@<Predecl...@>=
void  unbucket(eight_bits d);

@ @c
void
unbucket(eight_bits d) /* empties buckets having depth |d| */
@z

@x
@<Predecl...@>=
void section_print();
@y
@<Predecl...@>=
void section_print(name_pointer p);
@z

@x
@** Index.
@y
@ More function prototypes

@<Predecl...@>=
unsigned skip_TeX(void);
void new_xref(name_pointer p);
void set_file_flag(name_pointer p);
void new_section_xref(name_pointer p);
void out_str(char *s);
void finish_line(void);
void app_str(char *s);
extern void fatal(char *s, char *t);
token_pointer find_first_ident(text_pointer p);
void big_app1(scrap_pointer a);
void make_underlined(scrap_pointer p);
void make_reserved(scrap_pointer p);
text_pointer C_translate(void);
void pop_level(void);
void push_level(text_pointer p);
eight_bits get_output(void);
text_pointer translate(void);
void output_C(void);
void copy_limbo(void);
eight_bits copy_TeX(void);
void outer_parse(void);

@** Index.
@z