/*
 * rot13fs.c
 * simple rot13 crypt file server.
 *
 */

#include <olfs.h>


void 
usage(void)
{
	print("usage %s [-d] [-D] [-s srvname] [-m mtpt]  target\n",argv0);
	exits("usage");
}


void
rot13(char *s)
{
	while(*s!='\0'){
		if( (*s >='a' && *s <= 'm') || (*s >= 'A' && *s <='M') ){
			*s += 13;
		}else if( (*s >='n' && *s<='z') || ( *s>='N' && *s<='Z') ){
			*s -= 13;
		}
		s++;
	}
}



Olfs olfs = {
	.readfilter = rot13,
	.writefilter = rot13	
};



void
main(int argc, char **argv)
{
	char *srvname, *mtpt, *path;
	srvname = nil;
	mtpt = "/n/rot13fs";

	/* parse argument macro */
	ARGBEGIN{
	case 'D':
		chatty9p++;	/* debug flag */
		break;
	case 's':
		srvname = EARGF(usage());
		break;
	case 'm':
		mtpt = EARGF(usage());
		break;
	default:
		usage();
	}ARGEND;

	if(argc != 1)
		usage();


	if(*(argv[0]+strlen(argv[0])-1)!='/'){
		path = emalloc(strlen(argv[0])+2);
		sprint(path, "%s/",argv[0]);
	}else{
		path = estrdup(argv[0]);
	}

	olfs.realpath = estrdup(path);

	if(chatty9p)
		fprint(2,"srvname %s mtpt %s realpath %s\n",
			srvname, mtpt, path);

	postolfs(&olfs, srvname, mtpt, MBEFORE|MCREATE);
	exits(nil);
}
