#include <u.h>
#include <libc.h>
#include <stdio.h>
#include <fcall.h>
#include <thread.h>
#include <9p.h>


#pragma src "/sys/src/libolfs"
#pragma lib "libolfs.a"

#define emalloc emalloc9p
#define estrdup estrdup9p



typedef struct Olfs Olfs;
typedef struct Node Node;

struct Olfs {
	void (*attach)(Req *r);
	char* (*walk1)(Fid *fid, char *name, Qid *qid);
	char* (*clone)(Fid *ofid, Fid *fid);	
	void (*read)(Req *r);
	void (*write)(Req *r);
	void (*stat)(Req *);
	void (*wstat)(Req *r);
	void (*open)(Req *r);
	void (*destroyfid)(Fid *fid);
	void (*remove)(Req *r);
	void (*create)(Req *r);
	
	void (*readfilter)(char *buf);
	void (*writefilter)(char *buf);

	void (*fillstat)(Dir *dir, Dir *d, int isroot);
	void (*wfillstat)(Dir*dir, Node *np);
	int (*permconvert)(Req *r, int perm);
	int (*modeconvert)(Req *r, int mode);
	char* (*nameencode)(char *name);
	char* (*namedecode)(char *name);
	char *realpath;
	
};

struct Node
{
	char	*realname;
	Dir	*d, *dir;
	Node	*parent;
	int		fd;
	int		open;
	int	dirty, dirdirty;
	long files;
	Qid	qid;
};





void postolfs(Olfs *srv, char *srvname, char *mtpt, int flag);
int fsdirgen(int n, Dir *d, void *p);
void fillstat(Dir *dir, Dir *d, int isroot);
void wfillstat(Dir *dir, Node *np);
void nameencode(char *buf, char *raw, int n);
void namedecode(char *buf, char *raw, int n);

Node* newnode(Node *parent, char *name);
void nodedirread(Node *np);
void nodedirstat(Node *np);
Dir *reallocdir(Dir *d, int dofree);
