#include <olfs.h>
#include "node.h"

static Plist *pathlist;
char *realpath;

ulong
searchpath(char *name)
{
	static ulong path = 0;
	Plist *p;

	for(p = pathlist; p!=nil; p=p->next){
		if(strcmp(p->name, name) == 0){
			return p->path;
		}
	}

	p = (Plist*)emalloc(sizeof(Plist));
	p->name = estrdup(name);
	p->path = ++path;
	p->next = pathlist;
	pathlist = p;
	return p->path;

}



Node*
newnode(Node *parent, char *name)
{
	int plen;
	Node *np;
	char pathname[BUFSIZ];
	Dir *d;

	np = emalloc(sizeof(Node));
	np->fd = -1;
	np->open = 0;


	if(parent != nil){
		np->parent = parent;

		/* unless end with slash */
		plen = strlen(parent->realname);
		if(*(parent->realname+plen-1)!='/')
			sprint(pathname,"%s/%s",parent->realname,name);
		else
			sprint(pathname,"%s%s",parent->realname,name);


	}else{
		np->parent = np;
		sprint(pathname, "%s%s",realpath, name);
	}

	d = dirstat(pathname);

	if(! d){
		fprint(2, "can't stat %s\n", pathname);
		exits("can't stat");
	}
	np->qid.path = searchpath(pathname);
	np->qid.type = d->qid.type;
	np->realname = estrdup(pathname);

	nodedirstat(np);
	if(np->d->qid.type & QTDIR){
		nodedirread(np);
	}else{
		np->files = -1;
		np->dirdirty = 1;
		np->dir = nil;
	}

	return np;
}

void
nodedirstat(Node *np)
{
	np->d = dirstat(np->realname);
	if(! np->d){
		fprint(2,"can't stat %s\n", np->realname);
		exits("can't stat");
	}
	np->dirty = 0;
	
}

void
setpath(char *path)
{
	realpath = strdup(path);
}

Dir*
reallocdir(Dir *d, int dofree)
{
	Dir *dp;
	int nn, ng, nu, nm;

	if(d->name == nil)
		d->name = "?name?";
	if(d->uid == nil)
		d->uid = "?uid?";
	if(d->gid == nil)
		d->gid = d->uid;
	if(d->muid == nil)
		d->muid = d->uid;
	nn = strlen(d->name)+1;
	nu = strlen(d->uid)+1;
	ng = strlen(d->gid)+1;
	nm = strlen(d->muid)+1;
	dp = emalloc(sizeof(Dir)+nn+nu+ng+nm);
	*dp = *d;
	memcpy(dp->name, d->name,nn);
	memcpy(dp->uid, d->uid, nu);
	memcpy(dp->gid, d->gid, ng);
	memcpy(dp->muid, d->muid, nm);

	if(dofree)
		free(d);
	return dp;
}

void
nodedirread(Node *np)
{
	int fd;
	if(np->qid.type&QTDIR == 0){
		fprint(2,"node is not dir\n");
	}
	if( (fd = open(np->realname, OREAD)) <0){
		fprint(2, "can't open directory: %s",np->realname);
		exits("can't open directory");
	}

	np->files = dirreadall(fd, &(np->dir));
	np->dirdirty = 0;
	close(fd);
}
