/*
 * dmyfs.c
 *
 */

#include <olfs.h>


void 
usage(void)
{
	print("usage %s [-d] [-D] [-s srvname] [-m mtpt]  target\n",argv0);
	exits("usage");
}


Olfs olfs;

void
main(int argc, char **argv)
{
	char *srvname, *path;
	srvname = nil;

	/* parse argument macro */
	ARGBEGIN{
	case 'D':
		chatty9p++;	/* debug flag */
		break;
	case 's':
		srvname = EARGF(usage());
		break;
	default:
		usage();
	}ARGEND;

	if(argc != 1)
		usage();


	if(*(argv[0]+strlen(argv[0])-1)!='/'){
		path = emalloc(strlen(argv[0])+2);
		sprint(path, "%s/",argv[0]);
	}else{
		path = estrdup(argv[0]);
	}

	olfs.realpath = estrdup(path);


	postolfs(&olfs, srvname, path, MREPL|MCREATE);
	exits(nil);
}
