/*
 * caesarfs.c
 * simple rot13 crypt file server.
 *
 */

#include <olfs.h>
#include <auth.h>

static int cryptkey;


void 
usage(void)
{
	print("usage %s [-d] [-D] [-s srvname] [-m mtpt]  target\n",argv0);
	exits("usage");
}


void
caesar(int key, char *s)
{
	char base, c;

	print("caesar: key: %d\n",key);

	while(*s!='\0'){
		base = c = 0;
		if(  *s >= 'a' && *s <= 'z' ){
			base = 'a';
			c = *s - base;
		} else if( *s >= 'A' && *s <= 'Z'){
			base = 'A';
			c = *s - base;
		}
		
		c += key;

		if(c < 0)
			c +=  (-c /26 * 26)+26; 	

		c %= 26;

		if(base)
			*s = base + c;

		s++;
	}
}


static void
rfilter(char *buf)
{
	print("rfilter()\n");
	caesar(-cryptkey, buf);
}

static void
wfilter(char *buf)
{
	print("wfilter()\n");
	caesar(cryptkey, buf);
}


Olfs olfs = {
	.readfilter = rfilter,
	.writefilter = wfilter	
};

void
main(int argc, char **argv)
{
	char *srvname, *mtpt, *path;
	UserPasswd *up;

	srvname = nil;
	mtpt = "/n/caesarfs";


	/* parse argument macro */
	ARGBEGIN{
	case 'D':
		chatty9p++;	/* debug flag */
		break;
	case 's':
		srvname = EARGF(usage());
		break;
	case 'm':
		mtpt = EARGF(usage());
		break;
	default:
		usage();
	}ARGEND;

	if(argc != 1)
		usage();


	if(*(argv[0]+strlen(argv[0])-1)!='/'){
		path = emalloc(strlen(argv[0])+2);
		sprint(path, "%s/",argv[0]);
	}else{
		path = estrdup(argv[0]);
	}

	olfs.realpath = estrdup(path);

	if(chatty9p)
		fprint(2,"srvname %s mtpt %s realpath %s\n",
			srvname, mtpt, path);

	up = auth_getuserpasswd(auth_getkey, "proto=pass server=%s service=caesarfs", srvname);
	print("user: %s, passwd: %s\n", up->user, up->passwd);
	
	cryptkey = atoi(up->passwd);
	print("key: %d\n", cryptkey);

	postolfs(&olfs, srvname, mtpt, MBEFORE|MCREATE);
	exits(nil);
}
