#include <olfs.h>
#include <libsec.h>
#include <auth.h>

enum {
	COUNTERSIZE = 8,
	PHRASELEN = 256,
	MASKLEN = 512,
	DES3
};



typedef struct CryptKey CryptKey;
struct CryptKey {
	int algorithm;
	uchar mask[MASKLEN];
	int bsize;
	union {
		DES3state des3;
	} var;
};

void genkey(char *phrase, CryptKey *ckey);
void genmask(CryptKey *ckey);

void bufencrypt(CryptKey *ckey, uchar *buf, long len, long offset);
void bufdecrypt(CryptKey *ckey, uchar *buf, long len, long offset);
char *fnencrypt(CryptKey *ckey, char *name);
char *fndecrypt(CryptKey *ckey, char *name);


/* for DES3 */
void DES3encrypt(CryptKey *ckey, uchar *buf, long len, long offset);
void DES3decrypt(CryptKey *ckey, uchar *buf, long len, long offset);
char *DES3fnencrypt(CryptKey *ckey, char *name);
char *DES3fndecrypt(CryptKey *ckey, char *name);



