#include "cryptfs.h"


void
bufencrypt(CryptKey *ckey, uchar *buf, long len, long offset)
{
	switch(ckey->algorithm){
	case DES3:
		DES3encrypt(ckey, buf, len, offset);
		break;
	default:
		exits("invalid algorithm");
		break;
	}
}

void
bufdecrypt(CryptKey *ckey, uchar *buf, long len, long offset)
{
	switch(ckey->algorithm){
	case DES3:
		DES3decrypt(ckey, buf, len, offset);
		break;
	default:
		exits("invalid algorithm");
		break;
	}

}

char *
fnencrypt(CryptKey *ckey, char *name)
{
	switch(ckey->algorithm){
	case DES3:
		return DES3fnencrypt(ckey, name);
		break;
	default:
		exits("invalid algorithm");
		break;
	}
	return nil;
}

char *
fndecrypt(CryptKey *ckey, char *name)
{
	switch(ckey->algorithm){
	case DES3:
		return DES3fndecrypt(ckey, name);
		break;
	default:
		exits("invalid algorithm");
		break;
	}
	return nil;
}

void
genkey(char *phrase, CryptKey *ckey)
{
	uchar digest[2][SHA1dlen];
	uchar p[PHRASELEN];
	uchar key[3][8];
	
	memset(p, 0, sizeof(p));

	memccpy(p, phrase, '\0', sizeof(p));
	sha1(p, sizeof(p), digest[0], nil);
	sha1(digest[0], SHA1dlen, digest[1], nil);


	switch(ckey->algorithm){
	    case DES3:
		memmove(key[0], digest[0], 8);
		memmove(key[1], digest[0]+8, 8);
		memmove(key[2], digest[1], 8);
		setupDES3state( &(ckey->var.des3), key, 0);
		ckey->bsize = DESbsize;
		break;
	}

	genmask(ckey);
}

void
genmask(CryptKey *ckey)
{
	char counter[COUNTERSIZE];
	uchar *mask;
	int i;

	mask = ckey->mask;
	switch(ckey->algorithm){
	    case DES3:
		for(i=0;i<MASKLEN;i+=COUNTERSIZE){
			snprint(counter, sizeof(counter), "%07x", i/COUNTERSIZE);
			memcpy(mask+i, counter, sizeof(counter));
			// print("%d : %s : %s\n",i, counter, mask+i);			
		}
		des3ECBencrypt(mask, MASKLEN, &(ckey->var.des3));
		break;

	}
}
