#include "cryptfs.h"

void
DES3encrypt(CryptKey *ckey, uchar *buf, long len, long offset)
{
	int i;
	// fprint(2,"encrypt offset: %d , len: %d\n", offset, len);

	for(i=0;i<len;i++){
		*(buf+i) = *(buf+i) ^ ckey->mask[(offset+i)%MASKLEN];
	}

	des3ECBencrypt(buf, len, &(ckey->var.des3));
}


void
DES3decrypt(CryptKey *ckey, uchar *buf, long len, long offset)
{
	int i;
	// fprint(2,"decrypt offset: %d , len: %d\n", offset, len);
	des3ECBdecrypt(buf, len, &(ckey->var.des3));

	for(i=0;i<len;i++){
		*(buf+i) = *(buf+i) ^ ckey->mask[(offset+i)%MASKLEN];
	}
	

}

char *
DES3fnencrypt(CryptKey *ckey, char *name)
{
	uchar buf[FILENAME_MAX];
	char enc[FILENAME_MAX];
	int i, len;


	len = strlen(name);
	memcpy(buf, name, len);
	DES3encrypt(ckey, buf, len, 0);

	for(i=0; i<len; i++){
		snprint(enc+i*2, 3, "%02X", buf[i]);
	}
	*(enc+i*2) =  '\0';

	return strdup(enc);
}

char *
DES3fndecrypt(CryptKey *ckey, char *name)
{
	char buf[5], dec[FILENAME_MAX];
	int i, len;
	len = strlen(name);	
	len /=2;

	buf[0] = '0';
	buf[1] = 'x';
	buf[4] = '\0';
	for(i=0;i<len;i++){
		buf[2] = name[i*2];
		buf[3] = name[i*2+1];
		dec[i] = (char) atoi(buf);
	}
	dec[i] = '\0';
	DES3decrypt(ckey, (uchar*)dec, len, 0);

	return strdup(dec);
}
