/*
 * Simple client for libssh2. 
 * Andrey Mirtchovski, mirtchovski at gmail
 */ 

#include <libssh2.h>
#include <libssh2_sftp.h>

#include <unistd.h>

#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <stdlib.h>

//#include <libnet.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include "fns.h"
#include "dat.h"

char *pass;
char *keyfile1="lib/ssh/id_rsa.pub";
char *keyfile2="lib/ssh/id_rsa";

void 
kbd_callback(char *name, int name_len, 
             char *instruction, int instruction_len, int num_prompts,
             LIBSSH2_USERAUTH_KBDINT_PROMPT *prompts,
             LIBSSH2_USERAUTH_KBDINT_RESPONSE *responses,
             void **abstract)
{
    (void)name;
    (void)name_len;
    (void)instruction;
    (void)instruction_len;
    if (num_prompts == 1) {
        responses[0].text = strdup(pass);
        responses[0].length = strlen(pass);
    }
    (void)prompts;
    (void)abstract;
}

char*
buildcmd(int argc, char **argv)
{
	int i, len;
	char *s, *t;

	len = argc-1;
	for(i=0; i<argc; i++)
		len += strlen(argv[i]);
	s = malloc(len+1);
	if(!s)
		return NULL;
	t = s;
	for(i=0; i<argc; i++){
		if(i)
			*t++ = ' ';
		strcpy(t, argv[i]);
		t += strlen(t);
	}
	return s;
}

void
fromnet(LIBSSH2_SESSION *s, LIBSSH2_CHANNEL *c)
{
	char buf[Bufsize];
	int n;
	for(;;){
		if((n = libssh2_channel_read(c, buf, Bufsize)) > 0)
			write(1, buf, n);
		else
			goto Donenet;
	}
Donenet:
	if(n == EOF)
		libssh2_session_disconnect(s, "bye bye");

	/* notify child */
	libssh2_channel_free(c);
	kill(getppid(), SIGKILL);
	exit(21);
}

void
fromstdin(LIBSSH2_SESSION *s, LIBSSH2_CHANNEL *c, char *cmd)
{
	char buf[Bufsize];
	int n, pid;

	switch(pid = fork()){
	case -1:
		perror("fork");
		exit(1);
	case 0:
		break;
	default:
		return;
	}
	if(cmd && libssh2_channel_write(c, cmd, strlen(cmd)) != strlen(cmd))
		goto Donein;

	while((n = read(0, buf, Bufsize)) > 0) {
		if(libssh2_channel_write(c, buf, n) != n)
			goto Donein;
	}
	if(n == EOF)
		libssh2_session_disconnect(s, "bye bye");
Donein:
	libssh2_channel_free(c);
	kill(pid, SIGKILL);
	exit(31);
}

void
usage(char *pn)
{
	fprintf(stderr, "usage: %s [user@]host [cmd]\n", pn);
	exit(1);
}

int 
main(int argc, char *argv[])
{
	LIBSSH2_CHANNEL *channel;
	LIBSSH2_SESSION *session;
	const char *fingerprint;
	char *userauthlist;
	int debug = 0;
	char *host, *user = NULL, *cmd, *p;
	int fd, i;
	int sockbuf = 16384;
	struct hostent *h;
	struct sockaddr_in sin;
	int     sock = -1;
	int noblock = 1;
	unsigned short port = 22;

	if(argc < 2)
		usage(argv[0]);

	host = argv[1];

	cmd = NULL;
	if(argc > 2)
		cmd = buildcmd(argc-2, argv+2);

	if((p = strchr(host, '@')) != NULL){
		*p++ = '\0';
		user = host;
		host = p;
	}
	if(user == NULL)
		user = getenv("user");
	if(user == NULL) {
		fprintf(stderr, "cannot find user name\n");
		exit(2);
	}

	if (getenv("SSH2DEBUG"))
		debug = strtoul(getenv("SSH2DEBUG"), 0, 0);


  /*---- SET UP CLIENT SOCKET --------------*/
  if ((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0) {
    printf("Socket: %s", strerror(errno));
    return -1;
  }
  if (!(h = gethostbyname(host))) {
    printf("Can't find host named '%s'", host);
    return -1;
  }
  bzero((char *) &sin, sizeof(sin));
  sin.sin_family = AF_INET;
  bcopy(h->h_addr, (char *) &sin.sin_addr, h->h_length);
  sin.sin_port = htons((unsigned short) port);
  i = connect(sock, (struct sockaddr *) &sin, sizeof(sin));
print("connect is %d\n", i);
  if (i < 0) {
    printf("Connect failed: %s", strerror(errno));
    return -1;
  }
  fd = sock;
/*
	if((fd = dial(netmkaddr(host, "tcp", "ssh"), NULL, NULL, NULL)) < 0) {
		perror("can not dial host");
		exit(3);
	}*/
	/* Create a session instance and start it up
	 * This will trade welcome banners, exchange keys, and setup crypto, compression, and MAC layers
	 */
	session = libssh2_session_init();
libssh2_trace(session, debug);
	if (libssh2_session_startup(session, fd)) {
		fprintf(stderr, "Failure establishing SSH session\n");
		exit(41);
	}
	/* At this point we havn't authenticated,
	 * The first thing to do is check the hostkey's fingerprint against our known hosts
	 * Your app may have it hard coded, may go to a file, may present it to the user, that's your call
	 */
	fingerprint = libssh2_hostkey_hash(session, LIBSSH2_HOSTKEY_HASH_MD5);
	printf("Fingerprint: ");
	for(i = 0; i < 16; i++) {
		printf("%02X ", (unsigned char)fingerprint[i]);
	}
	printf("\n");

/* verify host against factotum */

	/* check what authentication methods are available */
	userauthlist = libssh2_userauth_list(session, user, strlen(user));
	printf("Authentication methods: %s\n", userauthlist);
/*	if (strstr(userauthlist, "publickey") != NULL) {
		char k1[512], k2[512];
		char *home = getenv("home");
		if(!home) {
			fprintf(stderr, "no $home\n");
			exit(4);
		}
		
		snprintf(k1, 511, "%s/lib/ssh/id_rsa.pub", home);
		snprintf(k2, 511, "%s/lib/ssh/id_rsa", home);
		if (libssh2_userauth_publickey_fromfile(session, user, k1, k2, pass)) {
			fprintf(stderr, "\tAuthentication by public key failed!\n");
			exit(5);
		} else {
			printf("\tAuthentication by public key succeeded.\n");
			goto Authed;
		}	
	}

	if (strstr(userauthlist, "keyboard-interactive") != NULL) {
		pass = getpass(host, user);
		if (libssh2_userauth_keyboard_interactive(session, user, &kbd_callback) ) {
			fprintf(stderr, "\tAuthentication by keyboard-interactive failed!\n");
			exit(6);
		} else {
			printf("\tAuthentication by keyboard-interactive succeeded.\n");
			goto Authed;
		}
	} 
*/
	if (strstr(userauthlist, "password") != NULL) {
		pass = getpass(host, user);
		if (libssh2_userauth_password(session, user, pass)) {
			fprintf(stderr, "\tAuthentication by password failed!\n");
			exit(7);
		} else {
			printf("\tAuthentication by password succeeded.\n");
			goto Authed;
		}
	} else {
		printf("No supported authentication methods found!\n");
		exit(8);
	}

Authed:

	if (!(channel = libssh2_channel_open_session(session))) {
		fprintf(stderr, "Unable to open a session\n");
		exit(9);
	}


	/* Request a terminal with vt102 terminal emulation
	 * This was previously 'vanilla', but vt102 works better in most cases
	 * See /etc/termcap for more options
	 */
	if (libssh2_channel_request_pty(channel, "vt102")) {
		fprintf(stderr, "Failed requesting pty\n");
		exit(10);
	}

	/* Open a SHELL on that pty */
	if (libssh2_channel_shell(channel)) {
		fprintf(stderr, "Unable to request shell on allocated pty\n");
		exit(11);
	}
	
	fromstdin(session, channel, cmd);
	fromnet(session, channel);
}
