/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

/* This is a generic package for keeping a top-10 list of objects of
/* formal type.
/*
/* Specification in Ada-style:
/* generic				-- 3 formals,supplied by #define
/*	TTSIZE: int;			-- the size of the top-N list
/*	type TTTYPE is private;		-- the type of the objects
/*	with function int TTBETTER(ip, jp) TTTYPE *ip, *jp;
/*					-- 1 if object *ip better than
/*					-- object *jp, 0 otherwise
/* package TOP is			-- reflected in top.h
/*	function InitTop();		-- clears the list
/*	function InsertTop(obj) TTTYPE *obj;
/*					-- accepts a (pointer to) an object
/*	-- a generator yields the objects in best-to-worst order:
/*	type TopGen is private;		-- to declare the generator
/*	function OpenTop(tg) TopGen *tg;-- starts the generator
/*	function TTTYPE *NextTop(tg) TopGen *tg;
/*					-- yields next object, moves generator
/*	NoObject: constant (TTTYPE*);	-- yielded at end-of-list
/*	function CloseTop(tg) TopGen *tg;-- stops the generator
/* end TOP				-- */
/* The application of this file must be preceded by
/* #include "top.h", which defines the interface, and by
/* #include "top.p", which defines the parameters of the instantiation.

/* package body TOP is			-- */
static TTTYPE val[TTSIZE];
static TTTYPE *list[TTSIZE];
static int cnt;

InitTop()	{
	cnt = 0;
}

InsertTop(obj) register TTTYPE *obj;	{
	register int i;

	if (cnt < TTSIZE)	{	/* there is still room */
		list[cnt] = &val[cnt];
		val[cnt++] = *obj;
	}
	else
	if (TTBETTER(obj, list[TTSIZE-1]))	{
		/* preferable to worst in set */
		*list[TTSIZE-1] = *obj;
	}
	else	return;			/* we're not interested */

	for (i = cnt-2; i >= 0 && TTBETTER(list[i+1], list[i]); i--)	{
		register TTTYPE *jp = list[i+1];
		list[i+1] = list[i];
		list[i] = jp;
	}
}

OpenTop(tg) register TopGen *tg;	{
	*tg = 0;
}

TTTYPE *
NextTop(tg) register TopGen *tg;	{
	return *tg >= cnt ? NoObject : list[(*tg)++];
}

CloseTop(tg) register TopGen *tg;	{
	*tg = TTSIZE;
}
/* end TOP				-- */
