/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

struct text	{
	char *tx_fname;		/* the file name */
	int tx_needed;		/* set if file plays a role in final output */
	unsigned int tx_start;	/* positions in buff for the text */
	unsigned int tx_limit;
};

struct chunk	{
	/* a chunk of text in various representations */
	struct text *ch_text;	/* a pointer to the file text */
	unsigned int ch_st_ch;	/* first in chunk, counted in C-chars */
	unsigned int ch_lm_ch;	/* first not in chunk */
	long ch_st_ls;		/* same in lseek positions */
	long ch_lm_ls;
	unsigned int ch_st_nl;	/* same in line numbers */
	unsigned int ch_lm_nl;
};

struct run	{		/* a 'run' of coincident chars */
	struct chunk rn_cn0;	/* chunk in left file */
	struct chunk rn_cn1;	/* chunk in right file */
	unsigned int rn_quality;
};
