/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

/*
	Interface between the language-dependent lex module and
	the stream module.
*/

/* communication variables */
extern int lex_no;	/* pass 1: return stream of C condensed chars */
			/* pass 2: return C-char/ASCII-char position
				pairs at each \n */
extern int lex_ch;	/* condensed C-char produced by pass 1 */
extern unsigned int lex_ch_cnt;
			/* C-char position reported at each \n by pass 2 */
extern long lex_ls_pos;	/* lseek position reported at each \n by pass 2 */

/* #defines for the lex module */
#define	cput(ch)	if (lex_ch_cnt++, lex_no == 1) \
				{lex_ch = ch; return 1;} else
#define	c_eol()		if (lex_no == 2) return 1; else
#define	count()		lex_ls_pos += yyleng
