/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	<stdio.h>
#include	"stream.h"

/* imports from the lex module */
extern int yylex();
extern yystart();
extern FILE *yyin;

int lex_no;		/* pass 1: return stream of C condensed chars */
			/* pass 2: return C-char/ASCII-char position
				pairs at each \n
			*/

int lex_ch;		/* condensed C-char produced by pass 1 */
unsigned int lex_ch_cnt;/* C-char position reported at each \n by pass 2 */
long lex_ls_pos;	/* lseek position reported at each \n by pass 2 */

int
OpenStream(pass, fname)
	char *fname;
{
	lex_no = pass;
	lex_ch_cnt = 0;
	lex_ls_pos = 0L;
	
	/* start the lex machine */
	yyin = fopen(fname, "r");
	yystart();
	return yyin != NULL;
}

int
NextChar(cp)		/* lex_no must be 1 */
	char *cp;
{
	if (!yylex())
		return -1;
	*cp = lex_ch;
	return 0;
}

int
NextPair(ccp, lsp)	/* lex_no must be 2 */
	unsigned int *ccp;
	long *lsp;
{
	if (!yylex())
		return -1;
	*ccp = lex_ch_cnt;
	*lsp = lex_ls_pos;
	return 0;
}

CloseStream()	{
	fclose(yyin);
}
