/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	"params.h"

int min_run_size = MIN_RUN;

char options[128];			/* for various, extensible flags */

main(argc, argv)
	char *argv[];
{
	argv++, argc--;			/* skip program name */

	while (argc > 0 && argv[0][0] == '-')	{
		char *par = &argv[0][1];
		
		while (*par)	{
			switch (*par)	{
			case 'r':
				min_run_size = atoi(argv[1]);
				argc--, argv++;
				break;
			default:
				options[*par]++;
				break;
			}
			par++;
		}
		argc--, argv++;
	}
	if (min_run_size == 0)
		error("Minimum run size equals 0");
	
	init_buff();
	
	/* Read the files */
	pass1(argv, argc);
	
	/* Set up the hash table */
	make_hash();
	
	/* Compare various files */
	compare();
	
	/* Delete hash table */
	free_hash();
	
	/* Find positions of found similarities */
	pass2();

	/* Print the similarities */
	pass3();
	return 0;
}
