/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	<stdio.h>
#include	"params.h"
#include	"text.h"
#include	"top.p"
#include	"top.h"
#include	"debug.h"

extern char options[];

static FILE *chunk_open();
static unsigned int fill_line();
static show_chunk(), show_line(), clear_line(), print_run();

#define	MAXLINE		(PAGE_WIDTH/2-2)

pass3()	{
	TopGen tp;
	struct run *run;

	OpenTop(&tp);
	while ((run = NextTop(&tp)), run != NoObject)	{
		print_run(run);
		show_chunk(run);
		printf("\n");
	}
	CloseTop(&tp);
}

static
print_run(run)
	struct run *run;
{
#if	DEBUG == 1
#include	"buff.h"
	unsigned int i;
	struct chunk *cnk0 = &run->rn_cn0;
	struct chunk *cnk1 = &run->rn_cn1;
	
	printf("File %s vs. file %s:\n",
		cnk0->ch_text->tx_fname,
		cnk1->ch_text->tx_fname
	);
	printf("from C-char %d,%d to %d,%d:",
		cnk0->ch_st_ch, cnk1->ch_st_ch,
		cnk0->ch_lm_ch, cnk1->ch_lm_ch
	);
	printf(" from ASCII-char %d,%d to %d,%d:",
		cnk0->ch_st_ls, cnk1->ch_st_ls,
		cnk0->ch_lm_ls, cnk1->ch_lm_ls
	);
	printf(" from lines %d,%d to %d,%d:",
		cnk0->ch_st_nl, cnk1->ch_st_nl,
		cnk0->ch_lm_nl - 1, cnk1->ch_lm_nl - 1
	);
	printf(" %d C-chars\n", run->rn_quality);
	
	/* show C-chars, with a one-char margin */
	for (	i = cnk0->ch_st_ch - 1;
		i < cnk0->ch_lm_ch + 1;
		i++
	)	{
		putchar(buff[cnk0->ch_text->tx_start + i]);
	}
	printf("\n");
	for (	i = cnk1->ch_st_ch - 1;
		i < cnk1->ch_lm_ch + 1;
		i++
	)	{
		putchar(buff[cnk1->ch_text->tx_start + i]);
	}
	printf("\n");
#endif	DEBUG == 1

#ifdef	lint
	run = run;
#endif	lint
}


static
show_chunk(run)
	struct run *run;
{
	/* The animals came in two by two ... */
	struct chunk *cnk0 = &run->rn_cn0;
	struct chunk *cnk1 = &run->rn_cn1;
	unsigned int nl_cnt0 = cnk0->ch_lm_nl - cnk0->ch_st_nl;
	unsigned int nl_cnt1 = cnk1->ch_lm_nl - cnk1->ch_st_nl;
	FILE *f0;
	FILE *f1;
	char line0[MAXLINE + 1];
	char line1[MAXLINE + 1];
	
	sprintf(line0, "%s: line %d-%d",
		cnk0->ch_text->tx_fname,
		cnk0->ch_st_nl, cnk0->ch_lm_nl - 1, run->rn_quality);
	sprintf(line1, "%s: line %d-%d",
		cnk1->ch_text->tx_fname,
		cnk1->ch_st_nl, cnk1->ch_lm_nl - 1, run->rn_quality);
	show_line(line0, line1);
	if (options['n'])
		return;			/* ... had enough so soon ... */

	f0 = chunk_open(cnk0);
	f1 = chunk_open(cnk1);
	
	/* fill lines and print them */
	while (nl_cnt0 != 0 || nl_cnt1 != 0)	{
		if (nl_cnt0)	{
			fill_line(f0, line0);
			nl_cnt0--;
		}
		else	clear_line(line0);
		if (nl_cnt1)	{
			fill_line(f1, line1);
			nl_cnt1--;
		}
		else	clear_line(line1);
		show_line(line0, line1);
	}
	
	fclose(f0);
	fclose(f1);
}

static FILE *
chunk_open(cnk)
	struct chunk *cnk;
{
	/*	opens the file in which the chunk resides and positions
		the file at the beginning of the chunk
	*/
	char *fname = cnk->ch_text->tx_fname;
	FILE *f = fopen(fname, "r");
	
	if (f == NULL)	{
		printf("*** File %s disappeared\n", fname);
		f = fopen("/dev/null", "r");
	}
	fseek(f, cnk->ch_st_ls, 0);
	return f;
}

static unsigned int
fill_line(f, ln)
	FILE *f;
	char ln[];
{
	/*	Reads one line from f and puts it in condensed form in ln.
	*/
	int ch;
	int indent = 0, lpos = 0;
	
	/* condense and skip initial blank */
	while ((ch = getc(f)), ch == ' ' || ch == '\t')	{
		if (ch == '\t')
			indent = 8;
		else
			indent++;
		if (indent == 8)	{
			/* every eight blanks give one blank */
			if (lpos < MAXLINE)
				ln[lpos++] = ' ';
			indent = 0;
		}
	}
	
	/* store the rest */
	while (ch >= 0 && ch != '\n')	{
		if (ch == '\t')		/* replace tabs by blanks */
			ch = ' ';
		if (lpos < MAXLINE)
			ln[lpos++] = ch;
		ch = getc(f);
	}
	ln[lpos] = '\0';		/* always room for this one */
}

static
clear_line(ln)
	char ln[];
{
	/* a simple null byte will suffice */
	ln[0] = '\0';
}

static
show_line(ln0, ln1)
	char ln0[], ln1[];
{
	int i;
	
	for (i = 0; i < MAXLINE && ln0[i] != '\0'; i++)
		putchar(ln0[i]);
	for (; i < MAXLINE; i++)
		putchar(' ');
	printf(" |");

	for (i = 0; i < MAXLINE && ln1[i] != '\0'; i++)
			putchar(ln1[i]);
	printf("\n");
}
