/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	"text.h"
#include	"top.p"
#include	"top.h"
#include	"debug.h"

extern int ntexts;
extern struct text *text;

static upd_top(), upd_chunk();

pass2()	{
	int n;
	
	for (n = 0; n < ntexts; n++)	{
		struct text *txt = &text[n];
		unsigned int ch_cnt;
		long ls_pos;
		unsigned int nl_cnt = 1;
	
		if (!txt->tx_needed)		/* an optimization */
			continue;
	
		if (!OpenStream(2, txt->tx_fname))	{
			printf("*** File %s disappeared\n", txt->tx_fname);
			OpenStream(2, "/dev/null");
		}
	
		while (NextPair(&ch_cnt, &ls_pos) == 0)	{
			/*	fill in the lseek and line positions
				in the collected runs
			*/
			nl_cnt++;
#if	DEBUG == 1
			printf("pass2 on %s: ch_cnt = %u, ls_pos = %ld\n",
					txt->tx_fname, ch_cnt, ls_pos);
#endif	DEBUG == 1
			upd_top(txt, ch_cnt, ls_pos, nl_cnt);
		}
		CloseStream();
	}
}

static
upd_top(txt, ch_cnt, ls_pos, nl_cnt)
	struct text *txt;
	unsigned int ch_cnt;
	long ls_pos;
	unsigned int nl_cnt;
{
	TopGen tp;
	struct run *run;
	
	OpenTop(&tp);
	while ((run = NextTop(&tp)), run != NoObject)	{
		struct chunk *cnk0 = &run->rn_cn0;
		struct chunk *cnk1 = &run->rn_cn1;
		
		if (cnk0->ch_text == txt)
			upd_chunk(cnk0, ch_cnt, ls_pos, nl_cnt);
		if (cnk1->ch_text == txt)
			upd_chunk(cnk1, ch_cnt, ls_pos, nl_cnt);
	}
	CloseTop(&tp);
}

static
upd_chunk(cnk, ch_cnt, ls_pos, nl_cnt)
	struct chunk *cnk;
	unsigned int ch_cnt;
	long ls_pos;
	unsigned int nl_cnt;
{
	if (ch_cnt <= cnk->ch_st_ch)	{
		cnk->ch_st_ls = ls_pos;
		cnk->ch_st_nl = nl_cnt;
	}
	if (cnk->ch_lm_ls == 0 && cnk->ch_lm_ch <= ch_cnt)	{
		cnk->ch_lm_ls = ls_pos;
		cnk->ch_lm_nl = nl_cnt;
	}
}
