/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	"buff.h"
#include	"text.h"

extern char *calloc();

struct text *text;		/* to be filled in by calloc */
int ntexts;			/* number of text records */

pass1(argv, argc)
	char *argv[];
{
	int n;
	
	/* allocate the array of text descriptors */
	ntexts = argc;
	text = (struct text *)calloc((unsigned)ntexts, sizeof (struct text));
	if (!text)
		error("Too many files");

	/* read the files */
	for (n = 0; n < ntexts; n++)	{
		char *fname = argv[n];
		struct text *txt = &text[n];
		char ch;
	
		printf("File %s: ", fname);
	
		txt->tx_fname = fname;
		txt->tx_start = txt->tx_limit = text_length();
		if (!OpenStream(1, txt->tx_fname))	{
			printf("cannot open\n");
			OpenStream(1, "/dev/null");
		}
		while (NextChar(&ch) == 0)
			store(ch);
		CloseStream();
	
		txt->tx_limit = text_length();
		printf("%u C-units\n", txt->tx_limit - txt->tx_start);
	}
	printf("Total: %u C-units\n", text_length() - 1);
	printf("\n");
}
