/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

/*
	This is a service program for the similarity tester.
	A call of 'cstream -1 inp.c' yields the tokens of inp.c as
	single characters, as used by pass1 of sim.
	A call of 'cstream -2 inp.c' yields a list of <token_number,
	character_number> pairs, one for each line.  This is used by
	pass3.
*/

#include	<stdio.h>

char options[128];

main(argc, argv)
	char *argv[];
{
	if (argc != 3)	{
		fprintf(stderr, "Call is: %s -[12] inp.c\n", argv[0]);
		return 1;
	}

	if (!OpenStream(argv[1][1] - '0', argv[2]))	{
		fprintf(stderr, "%s: cannot open\n", argv[2]);
		return 1;
	}

	if (argv[1][1] == '1')	{
		char ch;

		while (NextChar(&ch) == 0)
			putchar(ch);
	}
	else
	if (argv[1][1] == '2')	{
		unsigned int ch_cnt;
		long ls_pos;

		while (NextPair(&ch_cnt, &ls_pos) == 0)
			printf("%ld,%ld\n", ch_cnt, ls_pos);
	}
	return 0;
}
