/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	"buff.h"

#define	BFSIZE		10000

extern char *malloc(), *realloc(), *calloc();

char *buff;			/* to be filled by malloc */
static unsigned int buff_size;	/* size of buffer at this moment */
static unsigned int bfree;	/* next free position in array buff[] */

init_buff()	{
	/* Allocate the text buffer */
	buff = malloc(buff_size = BFSIZE);
	if (!buff)
		error("out of space");
	bfree = 1;				/* don't use position 0 */
}

store(ch)	{
	if (bfree == buff_size)	{
		buff = realloc(buff, buff_size += BFSIZE);
		if (!buff || buff_size < bfree)	{
			/* overflow */
			error("out of space");
		}
	}
	buff[bfree++] = ch;
}

unsigned int
text_length()	{
	return bfree;
}
