/*	This file is part of the software similarity tester SIM.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	"buff.h"
#include	"text.h"
#include	"top.p"
#include	"top.h"

static set_chunk();

add_run(txt0, i0, txt1, i1, size)
	struct text *txt0, *txt1;
	unsigned int i0, i1;
	unsigned int size;
{
	/*	Adds the run of given size to our collection.
	*/
	struct run r;
	
	set_chunk(&r.rn_cn0, txt0, i0 - txt0->tx_start, size);
	set_chunk(&r.rn_cn1, txt1, i1 - txt1->tx_start, size);
	r.rn_quality = size;
	
	InsertTop(&r);
}

static
set_chunk(cnk, txt, index, size)
	struct chunk *cnk;
	struct text *txt;
	unsigned int index;
	unsigned int size;
{
	/*	Fill the chunk *cnk with info about the piece of text
		in txt starting at index extending over size characters.
	*/
	txt->tx_needed = 1;
	cnk->ch_text = txt;
	cnk->ch_st_ch = index;
	cnk->ch_lm_ch = index + size;
	cnk->ch_st_ls = cnk->ch_lm_ls = 0;
	cnk->ch_st_nl = cnk->ch_lm_nl = 1;
}
