#include "lib.h"
#include "trie.h"

typedef struct Trie Trie;
struct Trie {
	Trie*	otherwise;
	Trie*	more;
	void*	value;
	char	ch;
};

void
trie_insert(Trie **r, char *s, void *value)
{
	Trie *p = nil;
	char ch;

	while((ch = *s++)) {
		while((p = *r)) {
			if(p->ch == ch)
				break;
			else
				r = &p->otherwise;
		}
		if(!p) {
			p = malloc(sizeof(*p));
			memset(p, 0, sizeof(*p));
			p->ch = ch;
			*r = p;
		}
		r = &p->more;
	}
	p->value = value;
}

void *
trie_lookup(Trie **r, char **sp)
{
	char	*s = *sp;
	char	*value = nil;
	char	ch;
	while((ch = *s)) {
		Trie ** l = r;
		Trie *p;
		while((p = *l)) {
			if(p->ch == ch)
				break;
			else
				l = &p->otherwise;
		}
		if(p) {
			*l = p->otherwise;
			p->otherwise = *r;
			*r = p;
			r = &p->more;
			value = (char *) p->value;
			s++;
		} else
			break;
	}
	*sp = s;
	return value;
}
