#include "lib.h"
#include <ctype.h>
#include <dbm.h>
#include "trie.h"
#include "darray.h"
#include "phones.h"

Trie*	phones;

static void 
enter_phones(void)
{
	int	i;
	char	*s;
	for(i = 1; (s = ph_name[i]); i++)
		trie_insert(&phones, s, (void * ) i);
}

static void
enter_words(Dbm *db, Biobuf *f)
{
	char	*buf, *s, *h;

	while((buf = Brdline(f, '\n')) != nil) {
		buf[Blinelen(f)-1] = 0;
		s = buf;
		h = strchr(s, '#');
		if(h)
			*h = '\0';
		while(isspace(*s))
			s++;
		if(*s) {
			char	*p = s;
			while(isalpha(*p) || *p == '-' || *p == '\'') {
				if(islower(*p))
					*p = toupper(*p);
				p++;
			}
			if(isspace(*p)) {
				char	codes[4096];
				char	*d = codes;
				int	ok = 1;
				Datum key;
				key.dptr = s;
				key.dsize = p - s;
				while(*p && ok) {
					unsigned	code;
					while(isspace(*p))
						p++;
					if(*p) {
						char	*e = p;
						while(isalpha(*e) || *e == '1' || *e == '2') {
							if(islower(*e))
								*e = toupper(*e);
							e++;
						}
						if(*e == '0')
							*e++ = ' ';
						if(e > p && (code = (unsigned) trie_lookup(&phones, &p)))
							*d++ = code;
						else {
							fprint(2, "Bad code %.*s>%s", (int)(p - s), s, p);
							ok = 0;
							break;
						}
					}
				}
				if(ok) {
					Datum data;
					data.dptr = codes;
					data.dsize = d - codes;
					dbmstore(db, key, data, DB_INSERT);
				}
			} else {
				if(*p != '(')
					fprint(2, "Ignore (%c) %s", *p, s);
			}
		}
	}
}

void
main(int argc, char **argv)
{
	Biobuf *f;
	Dbm *db;

	if(argc != 3) {
		fprint(2, "Usage: mkdictdb dict out.db\n");
		exits("usage");
	}
	f = Bopen(argv[1], OREAD);
	if(f == nil) {
		fprint(2, "mkdictdb: can't open %s: %r\n", argv[1]);
		exits("open");
	}
	db = dbmcreate(argv[2], 0666);
	if(db == nil) {
		fprint(2, "mkdictdb: can't create %s: %r\n", argv[2]);
		exits("create");
	}
	enter_phones();
	enter_words(db, f);
	dbmclose(db);
	Bterm(f);
	exits(nil);
}
