/*
 *	implementation details
 */
enum {
	PBLKSIZ = 512,
	DBLKSIZ = 4096
};

struct Dbm {
	int     dirf;                /* open directory file */
	int     pagf;                /* open page file */
	int     flags;
	long    maxbno;              /* last ``block'' in page file */
	long    bitno;
	long    hmask;
	long    blkno;               /* current page to read/write */
	long    pagbno;              /* current page in pagbuf */
	char    pagbuf[PBLKSIZ];     /* page file block buffer */
	long    dirbno;              /* current block in dirbuf */
	char    dirbuf[DBLKSIZ];     /* directory file block buffer */
};

#define dbrdonly(db)    (((db)->flags&03) == OREAD)
