#include "lib.h"
#include <ctype.h>
#include "nsynth.h"
#include "elements.h"
#include "darray.h"
#include "holmes.h"
#include "phfeat.h"
#include "getargs.h"

#define AMP_ADJ 14
//#define AMP_ADJ 0

Biobuf *par_file;
Biobuf *jsru_file;
int	speed = 1;

double	frac = 1.0;

typedef struct  {
	float	v;                        /* boundary value */
	int	t;                          /* transition time */
} slope_t;

typedef struct  {
	slope_t p[nEparm];
} trans_t;

typedef struct  {
	float	a;
	float	b;
	float	v;
} filter_t, *filter_ptr;

static void jsru_save(double f0, float *tp);

static float	
filter(filter_ptr p, Float v)
{
	return p->v = (p->a * v + p->b * p->v);
}

/* 'a' is dominant element, 'b' is dominated
   ext is flag to say to use external times from 'a' rather
   than internal i.e. ext != 0 if 'a' is NOT current element.

 */

static void
set_trans(slope_t *t, Elm *a, Elm *b, int ext, int e)
{
	int	i;
	for(i = 0; i < nEparm; i++) {
		t[i].t = ((ext) ? a->p[i].ed : a->p[i].id) * speed;
		if(t[i].t)
			t[i].v = a->p[i].fixd + (a->p[i].prop * b->p[i].stdy) * (float) 0.01;
		else
			t[i].v = b->p[i].stdy;
	}
}

/*              
   ______________ b
   /
   /
   /
   a____________/                 
   0   d
   ---------------t---------------
 */

static float	
linear(Float a, Float b, int t, int d)
{
	if(t <= 0)
		return a;
	else if(t >= d)
		return b;
	else {
		float	f = (float) t / (float) d;
		return a + (b - a) * f;
	}
}

static float	
interpolate(char *w, char *p, slope_t *s, slope_t *e, Float mid, int t, int d)
{
	float	steady = d -(s->t + e->t);
#ifdef DEBUG
	print("%4s %s s=%g,%d e=%g,%d m=%g,%g\n",
	    w, p, s->v, s->t, e->v, e->t, mid, steady);
#endif
	if(steady >= 0) {
		/* Value reaches stready state somewhere ... */
		if(t < s->t)
			return linear(s->v, mid, t, s->t);	/* initial transition */
		else {
			t -= s->t;
			if(t <= steady)
				return mid;                 /* steady state */
			else
				return linear(mid, e->v, (int) (t - steady), e->t);
			/* final transition */
		}
	} else {
		float	f = (float) 1.0 -((float) t / (float) d);
		float	sp = linear(s->v, mid, t, s->t);
		float	ep = linear(e->v, mid, d -t, e->t);
		return f * sp + ((float) 1.0 - f) * ep;
	}
}

unsigned
holmes(unsigned nelm,uchar *elm,unsigned nsamp, short *samp_base)
{
	filter_t flt[nEparm];
	klatt_frame_t pars;
	short	*samp = samp_base;
	Elm *le = &Elements[0];
	unsigned	i = 0;
	unsigned	tstress = 0;
	unsigned	ntstress = 0;
	slope_t stress_s;
	slope_t stress_e;
	float	top = 1.1 *def_pars.F0hz10;
	int	j;
	pars = def_pars;
	pars.FNPhz = le->p[fn].stdy;
	pars.B1phz = pars.B1hz = 60;
	pars.B2phz = pars.B2hz = 90;
	pars.B3phz = pars.B3hz = 150;
#ifdef NOTDEF
	pars.F4hz = 3500;
#endif
	pars.B4phz = def_pars.B4phz;

	/* flag new utterance */
	parwave_init(&klatt_global);

	/* Set stress attack/decay slope */
	stress_s.t = 40;
	stress_e.t = 40;
	stress_e.v = 0.0;

	for(j = 0; j < nEparm; j++) {
		flt[j].v = le->p[j].stdy;
		flt[j].a = frac;
		flt[j].b = (float) 1.0 - (float) frac;
	}
	while(i < nelm) {
		Elm *ce = &Elements[elm[i++]];
		unsigned	dur = elm[i++];
		i++; /* skip stress */
		/* Skip zero length elements which are only there to affect
      boundary values of adjacent elements
    */
		if(dur > 0) {
			Elm *ne = (i < nelm) ? &Elements[elm[i]] : &Elements[0];
			slope_t start[nEparm];
			slope_t end[nEparm];
			unsigned	t;

			if(ce->rk > le->rk) {
				if(par_file)
					Bprint(par_file, "# %s < %s\n", le->name, ce->name);
				set_trans(start, ce, le, 0, 's');
				/* we dominate last */
			} else {
				if(par_file)
					Bprint(par_file, "# %s >= %s\n", le->name, ce->name);
				set_trans(start, le, ce, 1, 's');
				/* last dominates us */
			}

			if(ne->rk > ce->rk) {
				if(par_file)
					Bprint(par_file, "# %s < %s\n", ce->name, ne->name);
				set_trans(end, ne, ce, 1, 'e');
				/* next dominates us */
			} else {
				if(par_file)
					Bprint(par_file, "# %s >= %s\n", ce->name, ne->name);
				set_trans(end, ce, ne, 0, 'e');
				/* we dominate next */
			}

			if(par_file) {
				int	j;
				Bprint(par_file, "# %s\n", ce->name);
				for(j = 0; j < nEparm; j++)
					Bprint(par_file, "%c%6s", (j) ? ' ' : '#', Ep_name[j]);
				Bprint(par_file, "\n");
				for(j = 0; j < nEparm; j++)
					Bprint(par_file, "%c%6.4g", (j) ? ' ' : '#', start[j].v);
				Bprint(par_file, "\n");
				for(j = 0; j < nEparm; j++)
					Bprint(par_file, "%c%6d", (j) ? ' ' : '#', start[j].t);
				Bprint(par_file, "\n");
			}

			for(t = 0; t < dur; t++, tstress++) {
				float	base = top *0.8 /* 3 * top / 5 */;
				float	tp[nEparm];
				int	j;

				if(tstress == ntstress) {
					unsigned	j = i;
					stress_s = stress_e;
					tstress = 0;
					ntstress = dur;
#ifdef DEBUG_STRESS
					print("Stress %g -> ", stress_s.v);
#endif
					while(j <= nelm) {
						Elm *e   = (j < nelm) ? &Elements[elm[j++]] : &Elements[0];
						unsigned	du = (j < nelm) ? elm[j++] : 0;
						unsigned	s  = (j < nelm) ? elm[j++] : 3;
						if(s || e->feat & vwl) {
							unsigned	d = 0;
							if(s)
								stress_e.v = (float) s / 3;
							else
								stress_e.v = (float) 0.1;
							do {
								d += du;
#ifdef DEBUG_STRESS
								print("%s", (e && e->dict) ? e->dict : "");
#endif
								e = (j < nelm) ? &Elements[elm[j++]] : &Elements[0];
								du = elm[j++];
							} while((e->feat & vwl) && elm[j++] == s);
							ntstress += d / 2;
							break;
						}
						ntstress += du;
					}
#ifdef DEBUG_STRESS
					print(" %g @ %d\n", stress_e.v, ntstress);
#endif
				}

				for(j = 0; j < nEparm; j++)
					tp[j] = filter(flt + j, interpolate(ce->name, Ep_name[j], &start[j], &end[j], (float) ce->p[j].stdy,
					     t, dur));

				/* Now call the synth for each frame */

				pars.F0hz10 = base + (top - base) * 
				    interpolate("", "f0", &stress_s, &stress_e, (float) 0, tstress, ntstress);

				pars.AVdb = pars.AVpdb = tp[av];
				pars.AF = tp[af];
				pars.FNZhz = tp[fn];
				pars.ASP = tp[asp];
				pars.Aturb = tp[avc];
				pars.B1phz = pars.B1hz = tp[b1];
				pars.B2phz = pars.B2hz = tp[b2];
				pars.B3phz = pars.B3hz = tp[b3];
				pars.F1hz = tp[f1];
				pars.F2hz = tp[f2];
				pars.F3hz = tp[f3];
				/* AMP_ADJ + is a bodge to get amplitudes up to klatt-compatible levels
          Needs to be fixed properly in tables
        */
				/*  pars.ANP  = AMP_ADJ + tp[an]; */
				pars.AB = AMP_ADJ + tp[ab];
				pars.A5 = AMP_ADJ + tp[a5];
				pars.A6 = AMP_ADJ + tp[a6];
				pars.A1 = AMP_ADJ + tp[a1];
				pars.A2 = AMP_ADJ + tp[a2];
				pars.A3 = AMP_ADJ + tp[a3];
				pars.A4 = AMP_ADJ + tp[a4];

				parwave(&klatt_global, &pars, samp);

				samp += klatt_global.nspfr;
				if(par_file) {
					for(j = 0; j < nEparm; j++)
						Bprint(par_file, " %6.4g", tp[j]);
					Bprint(par_file, "\n");
				}
				if(jsru_file)
					jsru_save(pars.F0hz10 * 0.1, tp);
				/* Declination of f0 envelope 0.25Hz / cS */
				top -= 0.5;
			}
			if(par_file) {
				int	j;
				for(j = 0; j < nEparm; j++)
					Bprint(par_file, "%c%6.4g", (j) ? ' ' : '#', end[j].v);
				Bprint(par_file, "\n");
				for(j = 0; j < nEparm; j++)
					Bprint(par_file, "%c%6d", (j) ? ' ' : '#', end[j].t);
				Bprint(par_file, "\n");
			}
		}
		le = ce;
	}
	return (samp - samp_base);
}

int
init_holmes(int argc, char *argv[])
{
	char	*par_name = nil;
	char	*jsru_name = nil;
	argc = getargs("Holmes", argc, argv,
	    "p", "", &par_name,  "Parameter file for plot",
	    "j", "", &jsru_name, "Data for alternate synth (JSRU)",
	    "S", "%d", &speed,   "Speed (1.0 is 'normal')",
	    "K", "%lg", &frac,   "Parameter filter 'fraction'",
	    nil);
	if(help_only)
		return argc;
	if(par_name) {
		par_file = Bopen(par_name, OWRITE);
		if(par_file == nil) {
			fprint(2, "%s: can't create %s: %r\n", "say", par_name);
			exits("err");
		}
	}
	if(jsru_name) {
		jsru_file = Bopen(jsru_name, OWRITE);
		if(jsru_file == nil) {
			fprint(2, "%s: can't create %s: %r\n", "say", jsru_name);
			exits("err");
		}
	}
	return argc;
}

void
term_holmes(void)
{
	if(par_file)
		Bterm(par_file);
	if(jsru_file)
		Bterm(jsru_file);
}

static int	
jsru_freq(Float f, Float base, Float inc)
{
	int	i;
	f = (f - base) / inc;
	i = (int) f;
	if(i >= 64)
		i = 63;
	return i;
}

static int	
jsru_amp(Float a)
{
	int	i = a;
	if(i <= 0)
		i = 1;
	if(i >= 64)
		i = 63;
	return i;
}

/*          0     1      2      3      4    5
   F1    F2     F3                 FN
   flflim 125.0 550.0 1350.0 3500.0 3500.0 95.0
   fincrm  25.0  50.0   50.0    0.0    0.0  5.0
 */

static void
jsru_save(double f0, float *tp)
{
	f0 = 16 * (log(f0 / 25.0) / log(2.0)) - 1;

	/* fn, alf, f1, a1, f2, a2, f3, a3, ahf, v, f0, m */
	Bputc(jsru_file, jsru_freq(tp[fn], 95.0, 5.0));
	Bputc(jsru_file, jsru_amp(tp[an]));
	Bputc(jsru_file, jsru_freq(tp[f1], 125.0, 25.0));
	Bputc(jsru_file, jsru_amp(tp[a1]));
	Bputc(jsru_file, jsru_freq(tp[f2], 550.0, 50.0));
	Bputc(jsru_file, jsru_amp(tp[a2]));
	Bputc(jsru_file, jsru_freq(tp[f3], 1350.0, 50.0));
	Bputc(jsru_file, jsru_amp(tp[a3]));
	Bputc(jsru_file, jsru_amp(tp[a4]));
	Bputc(jsru_file, jsru_amp(tp[av]));
	Bputc(jsru_file, (int) f0);
	Bputc(jsru_file, (int) 32);
}

