#include "lib.h"
#include <ctype.h>
#include "getargs.h"

int	help_only = 0;

/*
   Usage is like :

   argc = getargs("Module",argc,argv,
   "r", "%d", &rate,               "Integer",
   "u", "",   &ufile_name,         "String",
   "g", "%g", &gain,               "Double",
   "a", nil, &use_audio,          "Boolean -a toggles, +a sets",
   "s", ""  , &speaker,            "Booelan -s clears, +s sets",
   nil);

 */

enum { TNONE, TINT, TLONG, TDOUBLE };

static int
sscanf(char *s, int vtype, void *var)
{
	char *p;
	long l;
	double f;

	p = s;
	switch(vtype) {
	default:
		return 0;
	case TINT:
	case TLONG:
		l = strtol(s, &p, 0);
		if(*p)
			return 0;
		if(vtype == TINT)
			*(int*)var = l;
		else
			*(long*)var = l;
		break;
	case TDOUBLE:
		f = strtod(s, &p);
		if(*p)
			return 0;
		*(double*)var = f;
		break;
	}
	return 1;
}

int
getargs(char *module, int argc, char *argv[], ...)
{
	va_list ap;
	int	i = 0;
	int	done_module = 0;
	while(i < argc) {
		char	*s = argv[i];
		int	flag = *s++;
		if(*s && (flag == '-' || flag == '+')) {
			int	off = 1;
			while(*s) {
				char	*a;
				int	count = 0;
				va_start(ap, argv);
				while((a = va_arg(ap, char * ))) {
					int	l = strlen(a);
					char	*fmt = va_arg(ap, char *);
					void * var = va_arg(ap, void * );
					char	*desc = va_arg(ap, char *);
					char *x;
					int vtype;

					vtype = TNONE;
					if(fmt != nil && (x = strchr(fmt, '%')) != nil) {
						switch(x[strlen(x)-1]) {
						case 'e': case 'f': case 'g':
							vtype = TDOUBLE;
							break;
						case 'u': case 'd':
							if(x[1] == 'l')
								vtype = TLONG;
							else
								vtype = TINT;
							break;
						}
					}
					if(!strcmp(s, "-help")) {
						help_only = 1;
						if(!done_module++)
							fprint(2, "%s:\n", module);
						if(fmt) {
							x = strchr(fmt, '%');
							if(x) {
								fprint(2, " -%s <%s> [", a, x + 1);
								switch(vtype) {
								case TDOUBLE:
									fprint(2, fmt, *((double *) var));
									break;
								case TLONG:
									fprint(2, fmt, *((long *) var));
									break;
								case TINT:
									fprint(2, fmt, *((int *) var));
									break;
								}
								fprint(2, "]\t%s\n", desc);
							} else
								fprint(2, " -%s <string> [%s]\t%s\n", a,
								    *((char **) var) ? *((char **) var) : "", desc);
						} else {
							fprint(2, " [+|-]%s [%s]\t%s\n", a,
							    *((int *) var) ? "yes" : "no", desc);
						}
					} else if(l > 1) {
						if(!count && !strcmp(s, a)) {
							if(fmt) {
								if(i + off < argc) {
									char	*x = argv[i + off++];
									if(strchr(fmt, '%')) {
										if(sscanf(x, vtype, var) != 1)
											fprint(2, "%s : %s invalid after -%s\n", argv[0], x, a);
										} else
											*((char **) var) = x;
								} else
									fprint(2, "%s : no argument after -%s\n", argv[0], a);
							} else {
								if(flag == '+')
									*((int *) var) = !0;
								else
									*((int *) var) = !*((int *) var);
							}
							/* skip to end of string */
							count++;
							s += l;
							break;               /* out of va_arg loop */
						}
					} else {
						if(*s == *a) {
							if(fmt) {
								if(i + off < argc) {
									char	*x = argv[i + off++];
									if(strchr(fmt, '%')) {
										if(sscanf(x, vtype, var) != 1) {
											fprint(2, "%s : %s invalid after -%s\n", argv[0], x, a);
											exits("usage");
										}
									} else
										*((char **) var) = x;
								} else {
									fprint(2, "%s : no argument after -%s\n", argv[0], a);
									exits("usage");
								}
							} else {
								if(fmt || flag == '+')
									*((int *) var) = (flag == '+');
								else
									*((int *) var) = !*((int *) var);
							}
							count++;
							s++;
							break;               /* out of va_arg loop */
						}
					}
				}
				va_end(ap);
				if(!count) {
					off = 0;
					break;                   /* Out of s loop */
				}
			}
			if(off != 0) {
				int	j;
				argc -= off;
				for(j = i; j <= argc; j++)
					argv[j] = argv[j + off];
			} else
				i++;
		} else
			i++;
	}
	if(help_only && done_module)
		fprint(2, "\n");
	return argc;
}

