#include "lib.h"
#include <ctype.h>
#include "dict.h"
#include "phones.h"
#include "getargs.h"

static	Biobuf	bout;

static void 
show(char *s)
{
	uchar	*p;
	p = dict_find(s, strlen(s));
	Bprint(&bout, "%s", s);
	if(p) {
		int	l = strlen((char *)p);
		int	i;
		for(i = 0; i < l; i++)
			Bprint(&bout, " %s", ph_name[(unsigned) (p[i])]);
		Bprint(&bout, " [");
		for(i = 0; i < l; i++)
			Bprint(&bout, "%s", dialect[(unsigned) (p[i])]);
		Bprint(&bout, "]\n");
		free(p);
	} else
		Bprint(&bout, " ???\n");
}

void
main(int argc, char *argv[])
{
	Binit(&bout, 1, OWRITE);
	argc = dict_init(argc, argv);
	if(help_only) {
		fprint(2, "Usage: %s [options as above] words to lookup\n", argv[0]);
	} else {
		if(dict) {
			int	i;
			for(i = 1; i < argc; i++)
				show(argv[i]);
			dict_term();
		}
	}
	Bterm(&bout);
	exits(nil);
}

