#include "lib.h"
#include "phones.h"

char	**dialect = ph_am;
void *dict;

#ifdef HAVE_LIBDBM
#include <ctype.h>
#include <dbm.h>

#include "dict.h"
#include "getargs.h"

#ifndef DICT_DIR
#define DICT_DIR "/lib/say"
#endif

char	*dict_path = "b";

uchar *
dict_find(char *s, unsigned n)
{
	if(!n)
		n = strlen(s);
	if(dict) {
		Datum key, data;
		int i;
		key.dptr = malloc(n);
		key.dsize = n;
		for(i = 0; i < n; i++)
			key.dptr[i] = islower(s[i]) ? toupper(s[i]) : s[i];
		data = dbmfetch(dict, key);
		free(key.dptr);
		if(data.dptr) {
			uchar *w = malloc(data.dsize + 1);
			memmove(w, data.dptr, data.dsize);
			w[data.dsize] = 0;
			return w;
		}
	}
	return nil;
}

static void
choose_dialect(void)
{
	uchar *word = dict_find("schedule", 0);
	if(word) {
		if(word[0] == SH)
			dialect = ph_br;
		else if(word[0] == S && word[1] == K)
			dialect = ph_am;
		free(word);
	}
}

int
dict_init(int argc, char *argv[])
{
	char	*buf;
	argc = getargs("Dictionary", argc, argv, "d", "", &dict_path, "Which dictionary [b|a]", nil);
	if(!help_only) {
		buf = malloc(strlen(DICT_DIR) + strlen("Dict.db") + strlen(dict_path) + 2);
		sprint(buf, "%sDict.db", dict_path);
		if((dict = dbmopen(buf, OREAD)) == nil) {
			sprint(buf, "%s/%sDict.db", DICT_DIR, dict_path);
			dict = dbmopen(buf, OREAD);
		}
		if(dict != nil) {
			dict_path = realloc(buf, strlen(buf) + 1);
			choose_dialect();
		}
	}
	return argc;
}

void
dict_term(void)
{
	if(dict)
		dbmclose(dict);
}

#else

uchar*
dict_find(char *s, unsigned n)
{
	USED(s); USED(n);
	return nil;
}

int
dict_init(int argc, char *argv[])
{
	USED(argv);
	return argc;
}

void
dict_term(void)
{
}
#endif
