#include "lib.h"
#include "getargs.h"
#include "nsynth.h"
#include "hplay.h"

klatt_global_t klatt_global;

/* default values for pars array from .doc file */
klatt_frame_t def_pars = 
{
#include "pars.def"
};

/* Based on an idea by 

   John Cartmill   -  cartmill@wisconsin.nrlssc.navy.mil 

   The ability to read the user's  .sayrc file 
   ( which has the same format as  the pars.def file) 

   Not enabled by default as I don't have one other than 
   pars.def! to test it on and it does not handle comments  

 */

static void
read_rc_file(char *file)
{
	Biobuf *f;
	int i;
	char *line;
	union {
		klatt_frame_t def_pars;
		long	array[sizeof(klatt_frame_t)/sizeof(long)];	/* ick */
	} pars;

	f = Bopen(file, OREAD);
	if(f == nil){
		fprint(2, "%s: can't open %s: %r\n", program, file);
		exits("param");
	}
	for(i = 0; i < NPAR; ++i) {
		line = Brdline(f, '\n');
		if(line == nil)
			break;
		if(*line == '#')
			continue;
		line[Blinelen(f)-1] = 0;
		pars.array[i] = strtol(line, 0, 0);
	}
	def_pars = pars.def_pars;
	Bterm(f);
}

int
init_synth(int argc, char **argv)
{
	double	mSec_per_frame = 10;
	int	impulse = 0;
	int	casc = 0;
	char *paramfile = nil;
	klatt_global.samrate = samp_rate;
	klatt_global.quiet_flag = TRUE;
	klatt_global.glsource = NATURAL;
	klatt_global.f0_flutter = 0;

	argc = getargs("Synth paramters", argc, argv,
	    "q", nil, &klatt_global.quiet_flag, "Quiet - minimal messages",
	    "I", nil, &impulse,                 "Impulse glottal source",
	    "c", "%d", &casc,                    "Number cascade formants",
	    "F", "%d", &klatt_global.f0_flutter, "F0 flutter",
	    "f", "%lg", &mSec_per_frame,         "mSec per frame",
	    "t", "%d", &def_pars.TLTdb,          "Tilt dB",
	    "x", "%d", &def_pars.F0hz10,         "Base F0 in 0.1Hz",
	    "P", "", &paramfile, "Parameter file",
	    nil);

	if(paramfile != nil)
		read_rc_file(paramfile);
	if(casc > 0) {
		klatt_global.synthesis_model = CASCADE_PARALLEL;
		klatt_global.nfcascade = casc;
	} else
		klatt_global.synthesis_model = ALL_PARALLEL;

	if(impulse)
		klatt_global.glsource = IMPULSIVE;

	klatt_global.nspfr = (klatt_global.samrate * mSec_per_frame) / 1000;
#ifdef HAVE_NONSTDARITH
	/* turn off strict IEEE compliance in favour of speed */
	nonstandard_arithmetic();
#endif
	return argc;
}

