/* $Id: darray.h,v 1.13 1994/11/08 13:30:50 a904209 Exp a904209 $
*/
#ifndef DARRAY_H
#define DARRAY_H
typedef struct
 {char     *data;          /* the items */
  unsigned items;          /* number of slots used */
  unsigned alloc;          /* number of slots allocated */
  unsigned short esize;    /* size of items */
  unsigned short get;      /* number to get */
 } darray_t, *darray_ptr;

/* return pointer to nth item */
extern void *Darray_find(darray_t *a,unsigned n);
/* delete nth item */
extern int darray_delete(darray_t *a,unsigned n);
extern void darray_free (darray_t *a);

#define darray_init(a,sz,gt) \
 ((a)->esize = (sz), (a)->get = (gt), (a)->items = (a)->alloc = 0, (a)->data = nil)

#define darray_find(a,n) \
 (((n) < (a)->alloc && (n) < (a)->items) \
   ? (void *) ((a)->data + (n) * (a)->esize)  \
   : Darray_find(a,n))
#endif

