.TH Dbm 2X 
.SH NAME
dbmcreate, dbmopen, dbmfetch, dbmstore, dbmdelete, dbmfirstkey, dbmnextkey \- data base functions
.SH SYNOPSIS
.nf
.PP
.B #include <dbm.h>
.PP
.B Dbm *dbmcreate(char *file, int mode)
.PP
.B Dbm *dbmopen(char *file, int mode)
.PP
.B Datum dbmfetch(Dbm *db, Datum key)
.PP
.B int dbmstore(Dbm *db, Datum key, Datum content, int replace)
.PP
.B int dbmdelete(Dbm *db, Datum key)
.PP
.B Datum dbmfirstkey(Dbm *db)
.PP
.B Datum dbmnextkey(Dbm *db, Datum key)
.SH DESCRIPTION
These functions maintain
key/content pairs in a data base.
The functions will handle very large
(a billion blocks)
databases and will access a keyed item
in one or two filesystem accesses.
.PP
.IR Key s
and
.IR content s
are
described by the
.I Datum
typedef: which defines a structure with two visible fields,
.PP
.RS
.B char *dptr;
.nf
.B int dsize;
.RE
.PP
Each
.I Datum
specifies a string of
.I dsize
bytes pointed to by
.I dptr.
Arbitrary binary data, as well as normal
ASCII strings, are allowed.
The data base is stored in two files.
One file is a directory containing a bit map
and has `.dir' as its suffix.
The second file contains all data and
has `.pag' as its suffix.
.PP
A database is created by
.IR dbmcreate ,
which accepts a
.I mode
parameter
as described in
.IR creat (2),
and creates the two files
.IB file .dir
and
.IB file .pag .
.RI ( Dbmcreate
will truncate an existing database.)
If successful, it returns a pointer value describing the database, which
is open for reading and writing.
It returns a null pointer if it cannot create the database for some reason.
.PP
.I Dbmopen
accepts a
.I mode
parameter as described in
.IR open (2),
and opens the named database, which was previously created using
.IR dbmcreate .
If successful, it returns a pointer value descrbing the database,
which is open either for reading and writing, or only for reading,
as determined by
.IR mode .
.PP
The remaining functions accept the pointer value
returned by
.I dbmcreate
or
.I dbmopen
to select a database; more than one database may be accessed at once.
.PP
Once open,
the data stored under a key is
accessed by
.I dbmfetch
and data is placed under a key
by
.IR dbmstore .
If
.I replace
is
.SM DB_REPLACE
.I dbmstore
will simply replace the existing value by the new one if a key is already
in the database;
however, if
.I replace
is
.SM DB_INSERT
.I dbmstore
will return 0 if the new item was inserted, but
1 if the key already appears in the database,
and the new value will not be stored.
A key (and its associated contents)
is deleted by
.IR dbmdelete .
A linear pass through all keys in a database
may be made,
in an (apparently) random order,
by use of
.I dbmfirstkey
and
.IR dbmnextkey .
.I Dbmfirstkey
will return the first key
in the database.
With any key
.I dbmnextkey
will return the next key in the database.
This code will traverse the data base:
.IP
.EX
for(key=dbmfirstkey(db); key.dptr!=0; key=dbmnextkey(db, key))
.EE
.SH DIAGNOSTICS
All functions that return an
.I int
indicate errors with negative values.
A zero return indicates ok.
Routines that return a
.I Datum
indicate errors with a null (0)
.I dptr.
.I Dbmcreate
and
.I dbmclose
return a null pointer on failure to access the database,
leaving a more detailed error code for
.IR errstr (2).
.SH BUGS
The
`.pag'
file will contain holes so
that its apparent size is about
four times its actual content.
These files cannot be copied
by normal means (cp, cat, tar, ar)
without filling in the holes.
.PP
.I Dptr
pointers returned
by these subroutines
point into static storage
that is changed by subsequent calls.
.PP
The sum of the sizes of
a
key/content pair must not exceed
the internal block size
(currently 512 bytes).
Moreover all key/content pairs that hash
together must fit on a single block.
.I Dbmstore
will return an error in the event that
a disk block fills with inseparable data.
.PP
.I Dbmdelete
does not physically reclaim file space,
although it does make it available for reuse.
.PP
The order of keys presented by
.I dbmfirstkey
and
.I dbmnextkey
depends on a hashing function, not on anything
interesting.
