#pragma src "/sys/src/local/libdbm"
#pragma lib "libdbm.a"

typedef struct Dbm Dbm;
typedef struct Datum Datum;

struct Datum {
	char    *dptr;
	int     dsize;
};

/* command to dbmstore */
enum {DB_INSERT, DB_REPLACE};

Dbm	*dbmcreate(char *file, int mode);
Dbm	*dbmopen(char *file, int flags);
Datum	dbmfetch(Dbm *db, Datum key);
Datum	dbmfirstkey(Dbm *db);
Datum	dbmnextkey(Dbm *db, Datum key);
int	dbmdelete(Dbm *db, Datum key);
int	dbmstore(Dbm *db, Datum key, Datum dat, int replace);
void	dbmreset(Dbm *db);
void	dbmclose(Dbm *db);
