#include <u.h>
#include <libc.h>
#include "dbm.h"
#include "dbmx.h"

enum {
	BYTESIZ = 8,
	MAXNAME = 500,
};

#define	clrbuf(b,n) memset((b),0,(n))

static	int	GETS(void*, int);
static	void	PUTS(void*, int, int);

static	Datum	firsthash(Dbm *db, long int hash);
static	void	dbm_access(Dbm *db, long int hash);
static	int	getbit(Dbm *db);
static	Datum	makdatum(char *buf, int n);
static	int	cmpdatum(Datum d1, Datum d2);
static	long	hashinc(Dbm *db, long int hash);
static	long	calchash(Datum item);
static	void	setbit(Dbm *db);
static	void	delitem(char *buf, int n);
static	int	additem(char *buf, Datum item);
static	void	chkblk(char *buf);

Dbm *
dbmcreate(char *file, int mode)
{
	char name[MAXNAME+1];
	int pf, df;

	strcpy(name, file);
	strcat(name, ".pag");
	pf = create(name, OWRITE, mode);
	if (pf < 0)
		return 0;
	strcpy(name, file);
	strcat(name, ".dir");
	df = create(name, OWRITE, mode);
	close(pf);
	if (df < 0)
		return 0;
	close(df);
	return(dbmopen(file, ORDWR));
}

Dbm *
dbmopen(char *file, int flags)
{
	Dir statb;
	Dbm *db;

	if ((db = (Dbm *)malloc(sizeof *db)) == 0)
		return 0;
	if ((flags & 03) == OWRITE)
		flags = (flags & ~03) | ORDWR;
	db->flags = flags & 03;
	strcpy(db->pagbuf, file);
	strcat(db->pagbuf, ".pag");
	db->pagf = open(db->pagbuf, flags);
	if (db->pagf < 0) {
		free(db);
		return 0;
	}
	strcpy(db->pagbuf, file);
	strcat(db->pagbuf, ".dir");
	db->dirf = open(db->pagbuf, flags);
	if (db->dirf < 0) {
		close(db->pagf);
		free(db);
		return 0;
	}
	if (dirfstat(db->dirf, &statb) < 0)
		statb.length = 0;
	db->maxbno = statb.length*BYTESIZ-1;
	db->pagbno = db->dirbno = -1;
	return db;
}

void
dbmclose(Dbm *db)
{
	close(db->dirf);
	close(db->pagf);
	free(db);
}

void
dbmreset(Dbm *db)
{
	db->pagbno = db->dirbno = -1;
}

Datum
dbmfetch(Dbm *db, Datum key)
{
	int i;
	Datum item;

	dbm_access(db, calchash(key));
	for (i=0;; i+=2) {
		item = makdatum(db->pagbuf, i);
		if (item.dptr == 0)
			return item;
		if (cmpdatum(key, item) == 0) {
			item = makdatum(db->pagbuf, i+1);
			if (item.dptr == 0)
				fprint(2, "-ldbm: items not in pairs\n");
			return item;
		}
	}
}

int
dbmdelete(Dbm *db, Datum key)
{
	int i;
	Datum item;

	if (dbrdonly(db))
		return -1;
	dbm_access(db, calchash(key));
	for (i=0;; i+=2) {
		item = makdatum(db->pagbuf, i);
		if (item.dptr == 0)
			return -1;
		if (cmpdatum(key, item) == 0) {
			delitem(db->pagbuf, i);
			delitem(db->pagbuf, i);
			break;
		}
	}
	seek(db->pagf, db->blkno*PBLKSIZ, 0);
	write(db->pagf, db->pagbuf, PBLKSIZ);
	db->pagbno = db->blkno;
	return 0;
}

int
dbmstore(Dbm *db, Datum key, Datum dat, int replace)
{
	int i;
	Datum item;
	char ovfbuf[PBLKSIZ];

	if (dbrdonly(db))
		return -1;
loop:
	dbm_access(db, calchash(key));
	for (i=0;; i+=2) {
		item = makdatum(db->pagbuf, i);
		if (item.dptr == 0)
			break;
		if (cmpdatum(key, item) == 0) {
			if (replace == DB_INSERT)
				return 1;
			delitem(db->pagbuf, i);
			delitem(db->pagbuf, i);
			break;
		}
	}
	i = additem(db->pagbuf, key);
	if (i < 0)
		goto split;
	if (additem(db->pagbuf, dat) < 0) {
		delitem(db->pagbuf, i);
		goto split;
	}
	seek(db->pagf, db->blkno*PBLKSIZ, 0);
	write(db->pagf, db->pagbuf, PBLKSIZ);
	db->pagbno = db->blkno;
	return 0;

split:
	if (key.dsize+dat.dsize+3*sizeof(short) >= PBLKSIZ)
		return -1;
	clrbuf(ovfbuf, PBLKSIZ);
	for (i=0;;) {
		item = makdatum(db->pagbuf, i);
		if (item.dptr == 0)
			break;
		if (calchash(item) & (db->hmask+1)) {
			additem(ovfbuf, item);
			delitem(db->pagbuf, i);
			item = makdatum(db->pagbuf, i);
			if (item.dptr == 0) {
				fprint(2, "-ldbm: split not paired\n");
				break;
			}
			additem(ovfbuf, item);
			delitem(db->pagbuf, i);
			continue;
		}
		i += 2;
	}
	seek(db->pagf, db->blkno*PBLKSIZ, 0);
	write(db->pagf, db->pagbuf, PBLKSIZ);
	db->pagbno = db->blkno;
	seek(db->pagf, (db->blkno+db->hmask+1)*PBLKSIZ, 0);
	write(db->pagf, ovfbuf, PBLKSIZ);
	setbit(db);
	goto loop;
}

Datum
dbmfirstkey(Dbm *db)
{
	return firsthash(db, 0L);
}

Datum
dbmnextkey(Dbm *db, Datum key)
{
	int i;
	Datum item, bitem;
	long hash;
	int f;

	hash = calchash(key);
	dbm_access(db, hash);
	f = 1;
	for (i=0;; i+=2) {
		item = makdatum(db->pagbuf, i);
		if (item.dptr == 0)
			break;
		if (cmpdatum(key, item) <= 0)
			continue;
		if (f || cmpdatum(bitem, item) < 0) {
			bitem = item;
			f = 0;
		}
	}
	if (f == 0)
		return bitem;
	hash = hashinc(db, hash);
	if (hash == 0)
		return item;
	return firsthash(db, hash);
}

static Datum
firsthash(Dbm *db, long int hash)
{
	int i;
	Datum item, bitem;

loop:
	dbm_access(db, hash);
	bitem = makdatum(db->pagbuf, 0);
	for (i=2;; i+=2) {
		item = makdatum(db->pagbuf, i);
		if (item.dptr == 0)
			break;
		if (cmpdatum(bitem, item) < 0)
			bitem = item;
	}
	if (bitem.dptr != 0)
		return bitem;
	hash = hashinc(db, hash);
	if (hash == 0)
		return item;
	goto loop;
}

static void
dbm_access(Dbm *db, long int hash)
{
	for (db->hmask=0;; db->hmask=(db->hmask<<1)+1) {
		db->blkno = hash & db->hmask;
		db->bitno = db->blkno + db->hmask;
		if (getbit(db) == 0)
			break;
	}
	if (db->blkno != db->pagbno) {
		clrbuf(db->pagbuf, PBLKSIZ);
		seek(db->pagf, db->blkno*PBLKSIZ, 0);
		read(db->pagf, db->pagbuf, PBLKSIZ);
		chkblk(db->pagbuf);
		db->pagbno = db->blkno;
	}
}

static int
getbit(Dbm *db)
{
	long bn;
	int b, i, n;


	if (db->bitno > db->maxbno)
		return 0;
	n = db->bitno % BYTESIZ;
	bn = db->bitno / BYTESIZ;
	i = bn % DBLKSIZ;
	b = bn / DBLKSIZ;
	if (b != db->dirbno) {
		clrbuf(db->dirbuf, DBLKSIZ);
		seek(db->dirf, (long)b*DBLKSIZ, 0);
		read(db->dirf, db->dirbuf, DBLKSIZ);
		db->dirbno = b;
	}
	if (db->dirbuf[i] & (1<<n))
		return 1;
	return 0;
}

static void
setbit(Dbm *db)
{
	long bn;
	int i, n, b;

	if (db->bitno > db->maxbno) {
		db->maxbno = db->bitno;
		getbit(db);
	}
	n = db->bitno % BYTESIZ;
	bn = db->bitno / BYTESIZ;
	i = bn % DBLKSIZ;
	b = bn / DBLKSIZ;
	db->dirbuf[i] |= 1<<n;
	seek(db->dirf, (long)b*DBLKSIZ, 0);
	write(db->dirf, db->dirbuf, DBLKSIZ);
	db->dirbno = b;
}

static Datum
makdatum(char *buf, int n)
{
	int t, ne, v;
	Datum item;

	ne = GETS(buf, 0);
	if (n < 0 || n >= ne)
		goto null;
	t = PBLKSIZ;
	if (n > 0)
		t = GETS(buf, n+1-1);
	v = GETS(buf, n+1);
	item.dptr = buf+v;
	item.dsize = t - v;
	return item;

null:
	item.dptr = 0;
	item.dsize = 0;
	return item;
}

static int
cmpdatum(Datum d1, Datum d2)
{
	int n;
	uchar *p1, *p2;

	n = d1.dsize;
	if (n != d2.dsize)
		return n - d2.dsize;
	if (n == 0)
		return 0;
	p1 = (uchar*)d1.dptr;
	p2 = (uchar*)d2.dptr;
	do {
		if (*p1++ != *p2++)
			return *--p1 - *--p2;
	} while(--n);
	return 0;
}

static  int hitab[16]
/* ken's
{
	055,043,036,054,063,014,004,005,
	010,064,077,000,035,027,025,071,
};
*/
 = {    61, 57, 53, 49, 45, 41, 37, 33,
	29, 25, 21, 17, 13,  9,  5,  1,
};
static  long hltab[64]
 = {
	06100151277L,06106161736L,06452611562L,05001724107L,
	02614772546L,04120731531L,04665262210L,07347467531L,
	06735253126L,06042345173L,03072226605L,01464164730L,
	03247435524L,07652510057L,01546775256L,05714532133L,
	06173260402L,07517101630L,02431460343L,01743245566L,
	00261675137L,02433103631L,03421772437L,04447707466L,
	04435620103L,03757017115L,03641531772L,06767633246L,
	02673230344L,00260612216L,04133454451L,00615531516L,
	06137717526L,02574116560L,02304023373L,07061702261L,
	05153031405L,05322056705L,07401116734L,06552375715L,
	06165233473L,05311063631L,01212221723L,01052267235L,
	06000615237L,01075222665L,06330216006L,04402355630L,
	01451177262L,02000133436L,06025467062L,07121076461L,
	03123433522L,01010635225L,01716177066L,05161746527L,
	01736635071L,06243505026L,03637211610L,01756474365L,
	04723077174L,03642763134L,05750130273L,03655541561L,
};

static long
hashinc(Dbm *db, long int hash)
{
	long bit;

	hash &= db->hmask;
	bit = db->hmask+1;
	for (;;) {
		bit >>= 1;
		if (bit == 0)
			return 0;
		if ((hash&bit) == 0)
			return hash|bit;
		hash &= ~bit;
	}
}

static long
calchash(Datum item)
{
	int i, j, f;
	long hashl;
	int hashi;

	hashl = 0;
	hashi = 0;
	for (i=0; i<item.dsize; i++) {
		f = item.dptr[i];
		for (j=0; j<BYTESIZ; j+=4) {
			hashi += hitab[f&017];
			hashl += hltab[hashi&63];
			f >>= 4;
		}
	}
	return hashl;
}

static void
delitem(char *buf, int n)
{
	int i1, i2, i3;
	int ne;

	ne = GETS(buf, 0);
	if (n < 0 || n >= ne)
		goto bad;
	i1 = GETS(buf, n+1);
	i2 = PBLKSIZ;
	if (n > 0)
		i2 = GETS(buf, n+1-1);
	i3 = GETS(buf, ne+1-1);
	if (i2 > i1)
	while (i1 > i3) {
		i1--;
		i2--;
		buf[i2] = buf[i1];
		buf[i1] = 0;
	}
	i2 -= i1;
	for (i1=n+1; i1<ne; i1++)
		PUTS(buf, i1+1-1, GETS(buf, i1+1) + i2);
	PUTS(buf, 0, ne-1);
	PUTS(buf, ne, 0);
	return;

bad:
	fprint(2, "-ldbm: bad delitem\n");
	abort();
}

static int
additem(char *buf, Datum item)
{
	int i1, i2;
	int ne;

	i1 = PBLKSIZ;
	ne = GETS(buf, 0);
	if (ne > 0)
		i1 = GETS(buf, ne+1-1);
	i1 -= item.dsize;
	i2 = (ne+2) * sizeof(short);
	if (i1 <= i2)
		return -1;
	PUTS(buf, ne+1, i1);
	for (i2=0; i2<item.dsize; i2++) {
		buf[i1] = item.dptr[i2];
		i1++;
	}
	PUTS(buf, 0, ne+1);
	return ne;
}

static void
chkblk(char *buf)
{
	int t, i, ne, v;

	t = PBLKSIZ;
	ne = GETS(buf, 0);
	for (i=0; i<ne; i++) {
		v = GETS(buf,i+1);
		if (v > t)
			goto bad;
		t = v;
	}
	if (t < (ne+1)*sizeof(short))
		goto bad;
	return;

bad:
	fprint(2, "-ldbm: bad block\n");
	abort();
	clrbuf(buf, PBLKSIZ);
}

static int
GETS(void *buf, int sh)
{
	unsigned char *bp = (unsigned char*)buf + (sh<<1);

	return (short)((bp[0]<<8) | bp[1]);
}

static void
PUTS(void *buf, int sh, int v)
{
	unsigned char *bp = (unsigned char*)buf + (sh<<1);

	*bp++ = v>>8;
	*bp = v;
}
