#include "hex.h"

Window *w;
int dead;
char *binfile;

static int
iscmd(char *s, char *cmd)
{
	int len;

	len = strlen(cmd);
	return strncmp(s, cmd, len) == 0
		&& (s[len] == '\0'
			|| s[len] == ' '
			|| s[len] == '\t'
			|| s[len] == '\n');
}

static char*
skip(char *s, char *cmd)
{
	s += strlen(cmd);
	while(*s == ' ' || *s == '\t' || *s == '\n')
		s++;
	return s;
}

enum {
	Space = 50,
	Badchr = 51,
};

uchar
unhex(char c)
{
	if('0' <= c && c <= '9')
		return c-'0';
	else if('a' <= c && c <= 'f')
		return (c-'a') + 10;
	else if('A' <= c && c <= 'F')
		return (c-'A') + 10;
	else if(isspace(c))
		return Space;
	else
		return Badchr;
}

int
gethex(Biobuf *b)
{
	int c;

getc:
	if((c = Bgetc(b)) < 0)
		return c;
	c = unhex(c);
	switch(c){
	case Space:
		goto getc;
	case Badchr:
		fprint(2, "bad char at %s:#%lld,#%lld; ignoring\n",
			w->name, Boffset(b)-1, Boffset(b));
		goto getc;
	default:
		return c;
	}
}

void
put(void)
{
	char buf[64];
	char c0, c1;
	uchar byte;
	Biobuf *bo, *bi;
	
	sprint(buf, "/mnt/wsys/%d/body", w->id);
	bi = Bopen(buf, OREAD);
	if(bi == nil)
		sysfatal("open %s: %r", buf);
	bo = Bopen(binfile, OWRITE|OTRUNC);
	if(bo == nil)
		sysfatal("open %s: %r", binfile);
	
	for(;;){
		if((c0 = gethex(bi)) < 0)
			break;
		if((c1 = gethex(bi)) < 0)
			break;
		byte = ((uchar)c0<<4) | (c1&0xf);
		Bputc(bo, byte);
	}
	if(0 <= c0 && c0 <= 0xf)
		fprint(2, "extra half-byte not written\n");
	Bterm(bi);
	Bterm(bo);
	
	winclean(w);
}
	
int
docmd(char *cmd)
{
	cmd = skip(cmd, "");
	if(iscmd(cmd, "Del")){
		if(windel(w, 0))
			dead = 1;
		return 1;
	}
	if(iscmd(cmd, "Delete")){
		if(windel(w, 1))
			dead = 1;
		return 1;
	}
	if(iscmd(cmd, "Put")){
		put();
		return 1;
	}
	return 0;
}

void
acmeevent(Event *e)
{
	char *s;
	Event *e2;
	
	switch(e->c1){
	default:
	Unknown:
		fprint(2, "unknown message %c%c\n", e->c1, e->c2);
		break;
	
	case 'F':	/* generated by out actions */
	case 'E':	/* write to body or tag */
	case 'K':	/* keyboard input */
		break;
	
	case 'M':	/* mouse event */
		switch(e->c2){		/* type of action */
		case 'x':			/* button 2 in tag */
		case 'X':			/* button 2 in body */
			s = e->b;
			if(e->flag & 2){	/* null string with non-null expansion */
				e2 = recvp(w->cevent);
				if(e->nb==0)
					s = e2->b;
			}
			if(!docmd(s))
				winwriteevent(w, e);
			break;
		
		case 'l':	/* button 3 in tag */
		case 'L':	/* button 3 in body */
			winwriteevent(w, e);
			break;
		
		case 'i':	/* text insert in tag */
		case 'd':	/* text deleted from tag */
		case 'I':	/* text insert in body */
		case 'D':	/* text deleted from body */
			break;
			
		default:
			goto Unknown;
		}
		break;
	}
}


void
bodyproc(void*)
{
	Biobuf *bout, *bin;
	char buf[64];
	int c;
	
	threadsetname("bodyproc");
	
	bin = Bopen(binfile, OREAD);
	if(bin == nil)
		sysfatal("open %s: %r", binfile);
	sprint(buf, "/mnt/wsys/%d/body", w->id);
	bout = Bopen(buf, OWRITE);
	if(bout == nil)
		sysfatal("open %s: %r", buf);
	
	while((c = Bgetc(bin)) >= 0){
		Bprint(bout, "%02x", c);
		if(Boffset(bin)%16 == 0)
			Bprint(bout, "\n");
		else
			Bprint(bout, " ");
	}
	Bprint(bout, "\n");
	Bterm(bout);
	Bterm(bin);
	winclean(w);
}

void
usage(void)
{
	fprint(2, "usage: Hex file\n");
	threadexitsall("usage");
}

void
hexwinname(void)
{
	char path[90];
	int fd;
	
	fd = open(binfile, OREAD);
	if(fd < 0 || fd2path(fd, path, sizeof(path)))
		sysfatal("can't get rooted path: %r");
	close(fd);
	w->name = estrstrdup("/hex", path);
	winname(w, w->name);
}

void
threadmain(int argc, char **argv)
{
	Event *e;
	char *dump, *home;
	
	ARGBEGIN{
	}ARGEND;
	
	if(argc < 1)
		usage();
	
	binfile = argv[0];
	
	w = newwindow();
	hexwinname();
	fprint(w->ctl, "menu\n");
	wintagwrite(w, "|fmt -l47 ", 10);
	
	dump = estrstrdup("Hex ", binfile);
	home = getenv("home");
	winsetdump(w, home, dump);
	free(dump);
	free(home);
	
	proccreate(bodyproc, nil, STACK);
	proccreate(wineventproc, w, STACK);
	
	while(!dead && (e = recvp(w->cevent)))
		acmeevent(e);
	threadexits(nil);
}
