#include "u.h"
#include "libc.h"
#include "dat.h"
#include "fns.h"

static struct {
	Lock l;
	Chan *log, *cons;
	char logname[MAX_PATH];
} lg;

static void
vsyslog(int cons, char *logname, char *fmt, va_list a)
{
	static char buf[1024]; /* protected by lg.l */

	if(lg.logname[0] == 0){
		char *name;
		HANDLE h;

		initlock(&lg.l);
		lock(&lg.l);

		strncpy(lg.logname, logname, sizeof(lg.logname));

		lg.log = nil;
		lg.cons = nil;

		if(!waserror()){
			lg.cons = mkstdchan(2);
			poperror();
		}
		memset(buf, 0, sizeof(buf));
		GetModuleFileName(GetModuleHandle(nil), buf, sizeof(buf)-1);
		if(name = strrchr(buf, '\\')){
			name++;
		} else {
			strncpy(buf, "C:\\", sizeof(buf));
			name = buf + strlen(buf);
		}
		name += strlen(strncpy(name, logname, (buf + sizeof(buf)) - name));
		name += strlen(strncpy(name, ".log", (buf + sizeof(buf)) - name));
		if(h = CreateFile(buf, GENERIC_WRITE, FILE_SHARE_READ, nil, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, nil)){
			LONG loff, hoff;

			loff = hoff = 0;
			if((loff = SetFilePointer(h, 0, &hoff, FILE_END)) == INVALID_SET_FILE_POINTER){
				CloseHandle(h);
			} else {
				lg.log = mkfilechan(h);
				lg.log->off = (vlong)hoff << 32 | loff;
			}
		}
	} else {
		lock(&lg.l);
	}
	vsnprintf(buf, sizeof(buf), fmt, a);
	if(cons && lg.cons){
		if(!waserror()){
			chanprint(lg.cons, "%s\n", buf);
			poperror();
		}
	}
	if(lg.log){
		if(!waserror()){
			chanprint(lg.log, "%s\r\n", buf);
			poperror();
		}
	}
	unlock(&lg.l);
}

void
syslog(int cons, char *logname, char *fmt, ...)
{
	va_list a;

	va_start(a, fmt);
	vsyslog(cons, logname, fmt, a);
}
