/* no strncpy_s warning */
#define _CRT_SECURE_NO_WARNINGS

#include <stdio.h>
#include <winsock2.h>
#include <windows.h>
#include <setjmp.h>

typedef struct Qid Qid;
typedef struct Errjmp Errjmp;
typedef struct Lock Lock;
typedef struct Rendez Rendez;
typedef struct Thread Thread;

#define nil NULL
#define nelem(x) (sizeof(x)/sizeof((x)[0]))

struct Qid
{
	uvlong	path;
	ulong	vers;
	uchar	type;
};

enum {
	ERRMAX = 256,
	STACKSIZE = 64*1024,
};

extern char Eintr[];
extern char Ehungup[];
extern char Emountrpc[];

#define ARGF (--argc, *++argv)
#define EARGF(x) ((argc <= 0) ? ((x), nil) : ARGF)
#define ARGBEGIN ARGF; while((argc > 0) && (argv[0][0] == '-')){switch(argv[0][1])
#define ARGEND ARGF;}

void __abort(void);
#define assert(x) if(!(x)) __abort()

void *mallocz(int len, int zero);

/* shutup the compiler */
#define strdup _strdup
#define snprintf _snprintf

struct Lock
{
	CRITICAL_SECTION cs;
};

struct Rendez
{
	Lock l;
	Thread *t;
};

struct Errjmp
{
	jmp_buf	jmp;
};

struct Thread
{
	Thread *next;
	int pid;

	Lock l;
	Rendez *r;
	HANDLE ev;
	char *note;

	Errjmp err[16], *errp;
	char errstr[ERRMAX];
};

int getpid(void);
HANDLE getevent(void);
int threadcreate(void (*proc)(void *), void *arg);
int threadnotify(int pid, char *note);
void checkinterrupt(void);

void initlock(Lock *);
void freelock(Lock *);
void lock(Lock *);
void unlock(Lock *);
void freelock(Lock *);

int return0(void *);
void initrendez(Rendez *);
void freerendez(Rendez *);
int rwakeup(Rendez *);
void rsleep(Rendez *, int (*test)(void *), void *);

#define incref(x)	InterlockedIncrement(x)
#define decref(x)	InterlockedDecrement(x)

Errjmp *pusherror(void);
Errjmp *poperror(void);
#define waserror()	setjmp(pusherror()->jmp)
#define nexterror()	longjmp(poperror()->jmp, 1)
char *errorstr(void);
void error(char *fmt, ...);

void main(int argc, char *argv[]);
