#include "u.h"
#include "libc.h"
#include "dat.h"
#include "fns.h"

typedef struct FileAux FileAux;
struct FileAux
{
	Lock l;
	HANDLE h;
};

static int
readfile(Chan *ch, void *data, int len, vlong off)
{
	DWORD ret;
	FileAux *a;

	a = ch->aux;
	lock(&a->l);
	if(waserror()){
		unlock(&a->l);
		nexterror();
	}
	if(ch->off != off){
		LONG loff, hoff;
		loff = off & 0xFFFFFFFF;
		hoff = off >> 32;
		if(SetFilePointer(a->h, loff, &hoff, FILE_BEGIN) == INVALID_SET_FILE_POINTER)
			error("SetFilePointer: %x", GetLastError());
	}
	if(!ReadFile(a->h, data, len, &ret, 0))
		error("ReadFile: %x", GetLastError());
	poperror();
	unlock(&a->l);
	return ret;
}

static int
writefile(Chan *ch, void *data, int len, vlong off)
{
	DWORD ret;
	FileAux *a;

	a = ch->aux;
	lock(&a->l);
	if(waserror()){
		unlock(&a->l);
		nexterror();
	}
	if(ch->off != off){
		LONG loff, hoff;
		loff = off & 0xFFFFFFFF;
		hoff = off >> 32;
		if(SetFilePointer(a->h, loff, &hoff, FILE_BEGIN) == INVALID_SET_FILE_POINTER)
			error("SetFilePointer: %x", GetLastError());
	}
	if(!WriteFile(a->h, data, len, &ret, 0))
		error("WriteFile: %x", GetLastError());
	poperror();
	unlock(&a->l);
	return ret;
}
static void
closefile(Chan *ch)
{
	FileAux *a;

	a = ch->aux;
	CloseHandle(a->h);
	freelock(&a->l);
	free(a);
}

HANDLE*
pfilehandle(Chan *ch)
{
	FileAux *a;

	a = ch->aux;
	return &a->h;
}

Chan*
mkfilechan(HANDLE h)
{
	FileAux *a;
	Chan *ch;

	a = mallocz(sizeof(*a), 1);
	a->h = h;
	initlock(&a->l);

	ch = mkchan();
	ch->aux = a;
	ch->read = readfile;
	ch->write = writefile;
	ch->close = closefile;
	return ch;
}

int
mkpipechan(Chan *ch[2])
{
	SECURITY_ATTRIBUTES sa;
	HANDLE h[2];

	memset(&sa, 0, sizeof(sa));
	sa.nLength = sizeof(sa);
	sa.lpSecurityDescriptor = nil;
	sa.bInheritHandle = TRUE;
	if(!CreatePipe(&h[0], &h[1], &sa, 0))
		error("CreatePipe: err=%x", GetLastError());
	ch[0] = mkfilechan(h[0]);
	ch[1] = mkfilechan(h[1]);
	return 0;
}

Chan*
mkstdchan(int what)
{
	HANDLE h;
	static DWORD a[] = { STD_INPUT_HANDLE, STD_OUTPUT_HANDLE, STD_ERROR_HANDLE };
	
	if(what < 0 || what >= nelem(a) || (h = GetStdHandle(a[what])) == nil)
		error("bad std handle");
	return mkfilechan(h);
}
