typedef struct Chan Chan;
typedef struct Mnt Mnt;

struct Chan
{
	long	ref;
	long	closed;

	vlong	off;
	ulong	iounit;
	Qid		qid;
	ulong	fid;

	Mnt		*mnt;
	Chan	*mchan;	/* protected by mnt->ref */

	int		(*read)(Chan *c, void *data, int len, vlong off);
	int		(*write)(Chan *c, void *data, int len, vlong off);
	void	(*close)(Chan *c);

	void	*aux;
};

struct Mnt
{
	long	ref;

	int		pid;
	void	*queue;
	Chan	*c;
	char	*version;
	ulong	msize;
	Lock	l;
};

enum {
	MaxStr = 128,
};

