#include "u.h"
#include "libc.h"
#include "dat.h"
#include "fns.h"

Chan*
mkchan(void)
{
	Chan *ch;
	static ulong fidgen = 1;

	ch = mallocz(sizeof(*ch), 1);
	ch->ref = 1;
	ch->closed = 0;
	ch->fid = incref(&fidgen);
	ch->iounit = 0;
	return ch;
}

Chan*
getchan(Chan *ch)
{
	if(ch)
		incref(&ch->ref);
	return ch;
}

int readchan(Chan *ch, void *data, int len, vlong off)
{
	int n;

	if(ch->closed)
		error(Ehungup);
	if((n = ch->read(ch, data, len, off)) >= 0)
		ch->off = off + n;
	return n;
}

int writechan(Chan *ch, void *data, int len, vlong off)
{
	int n;

	if(ch->closed)
		error(Ehungup);
	if((n = ch->write(ch, data, len, off)) >= 0)
		ch->off = off + n;
	return n;
}

void closechan(Chan *ch)
{
	if(incref(&ch->closed) == 1)
		ch->close(ch);
}

void
freechan(Chan *ch)
{
	if(ch && decref(&ch->ref) == 0){
		closechan(ch);
		freemount(ch->mnt);
		free(ch);
	}
}

static int
readio(Chan *ch, void *data, int len, vlong off)
{
	Chan **aux;

	aux = ch->aux;
	return readchan(aux[0], data, len, off);
}
static int
writeio(Chan *ch, void *data, int len, vlong off)
{
	Chan **aux;

	aux = ch->aux;
	return writechan(aux[1], data, len, off);
}
static void
closeio(Chan *ch)
{
	Chan **aux;

	aux = ch->aux;
	freechan(aux[0]);
	freechan(aux[1]);
	free(aux);
}

Chan*
mkiochan(Chan *cin, Chan *cout)
{
	Chan **aux, *ch;

	if(cin == cout)
		return cin;
	aux = mallocz(sizeof(aux[0])*2, 1);
	aux[0] = cin;
	aux[1] = cout;
	ch = mkchan();
	ch->aux = aux;
	ch->close = closeio;
	ch->read = readio;
	ch->write = writeio;
	return ch;
}

int
vchanprint(Chan *ch, char *fmt, va_list a)
{
	char buf[1024];
	int n;

	n = vsnprintf(buf, sizeof(buf), fmt, a);
	if(ch != nil)
		writechan(ch, buf, n, ch->off);
	return n;
}

int
chanprint(Chan *ch, char *fmt, ...)
{
	va_list a;

	va_start(a, fmt);
	return vchanprint(ch, fmt, a);
}
