#include "u.h"
#include "libc.h"
#include "dat.h"
#include "fns.h"

static Chan*
noauth(Chan *ch, char *param, char *user, int nuser, HANDLE *pusertok)
{
	strncpy(user, "none", nuser);
	return ch;
}

static Chan*
tlspassauth(Chan *ch, char *param, char *user, int nuser, HANDLE *putok)
{
	char cert[MaxStr];
	char passwd[32];
	char *dom;

	ch = tlsserver(ch, getconfstr("tlscertsubject", cert, sizeof(cert)));
	if(readstr(ch, user, nuser) < 0)
		error("read username");
	if(dom = strchr(user, '@'))
		*dom++ = 0;
	else
		dom = ".";
	if(readstr(ch, passwd, sizeof(passwd)) < 0)
		error("read passwd");
	if(!LogonUser(user, dom, passwd, LOGON32_LOGON_INTERACTIVE, LOGON32_PROVIDER_DEFAULT, putok)){
badlogon:
		memset(passwd, 0, sizeof(passwd));
		writestr(ch, "bad logon", "error", 1);
		error("bad logon");
	}
	if(!ImpersonateLoggedOnUser(*putok))
		goto badlogon;
	memset(passwd, 0, sizeof(passwd));
	writestr(ch, "", "", 1);
	return ch;
}

struct {
	char	*name;
	Chan*	(*auth)(Chan *ch, char *param, char *user, int nuser, HANDLE *pusertok);
} authmethod[] = {
	"tlspass",	tlspassauth,
//	"none",		noauth,
};

Chan*
doauth(Chan *ch, char *method, char *param, char * user, int nuser, HANDLE *putok)
{
	int i;

	for(i = 0; i < nelem(authmethod); i++)
		if(strcmp(method, authmethod[i].name) == 0)
			break;
	if(i == nelem(authmethod)){
		writestr(ch, "unsupported auth method", nil, 0);
		error("unsupported auth method");
	}
	writestr(ch, "", "", 1);
	return (*authmethod[i].auth)(ch, param, user, nuser, putok);
}
