-- libxio ver. 1.1
-- io extension that support unread() and alarm read/write
-- you need 9lua
-- coded by Kenar (Kenji arisawa)

sub = string.sub
find = string.find


		-- unread io functions --

function open(name,opt)
  local fd,r,obj
  obj={
  ["fd"] = nil,
  ["buf"] = "",
  ["close"] = close,
  ["read"] = read,
  ["readn"] = readn,
  ["readln"] = readln,
  ["unread"] = unread,
  ["write"] = write,
  }
  if name == nil then
    return obj
  end
  fd,r = p9.open(name,opt)
  if r then
    return nil,r
  end
  obj.fd = fd
  return obj
end

function close(self)
  if self.fd then
    p9.close(self.fd)
  end
  self.fd = nil
  return
end

function read(self,size)
  local s,b,r
  if size == nil then
    b = self.buf
    self.buf = ""
    s,r = p9.read(self.fd)
    if s == nil then
      return b,r
    end
    return b .. s,r
  end
  if size <= #self.buf then
    b = self.buf
    self.buf = sub(b,size+1)
    return sub(b,1,size)
  end
  b = self.buf
  self.buf = ""
  s,r = p9.read(self.fd,size - #b)
  if s == nil then
    if b == "" then
      return nil,r
    end
    return b,r
  end
  return b .. s,r
end

function unread(self,str)
  self.buf = str .. self.buf
end

function readn(self,m)
  -- simulate Plan 9 readn
  local n = m
  local t,s,r
  t = ""
  repeat
    s,r = read(self,n)
    if s == nil then
      if r == nil then
        return t,"eof" -- premature eof
      end
      return nil,r -- read error
    end
    n = n - #s
    t = t .. s
  until n == 0
  return t
end

function readln(self)
  -- readln tries to read a line(a line that end with "\n")
  -- if a file does not end with "\n", then readln read until EOF with status "eof"
  local size = 16*1024
  local n,s
  s = self.buf
  n = find(s,"\n",1,true)
  if n then
    self.buf = sub(s,n+1)
    return sub(s,1,n)
  end
  repeat
    t,r = p9.read(self.fd,size)
    if t == nil then
      if #s > 0 then
        self.buf = ""
        return s,"eof" -- premature eof
      end
      return nil,r
    end
    s = s .. t
    n = find(s,"\n",1,true)
  until n
  self.buf = sub(s,n+1)
  return sub(s,1,n)
end

function write(self,str)
  return p9.write(self.fd, str)
end

--[[
	You can either:
	f = xio.open("foo")
    f:read()
    f:close()
	or
	f = xio.open("foo")
	xio.read(f)
	xio.close(f)
--]]

return {
	open=open,
	close=close,
	read=read,
	unread=unread,
	readn=readn,
	readln=readln,
	write=write
}
