-- under construction

-- libtls ver. 0.0
-- you need lua with plan9 extension
-- coded by Kenar (Kenji arisawa)

            -- some TLS stuffs --

module("tls",package.seeall)

version = "0x301"

sub = string.sub
gsub = string.gsub
char = string.char


function pushtls(fd,hashalg,encal,isclient,secret)
  -- under construction (not tested)
  -- Ref: /sys/src/libc/9sys/pushtls.c
  -- Look also RFC2246, pushtls(2), tls(3)
  -- suppeted hashalg and encal are obtained by
  --   cat '#a/tls/hashalgs'  --> clear md5 sha1
  --   cat '#a/tls/encalgs'   --> clear rc4_128 3des_ede_cbc
  local function fprint(fd,fmt,...)
    return p9.write(fd,format(fmt,...))
  end

  local TLSFinishedLen = 12  -- what is this vale?
  local HFinished = 20
  local function finished(hand,isclient)
    m = char(HFinished,p9.bit(TLSFinishedLen,">>",16),
      p9.bit(TLSFinishedLen,">>",8),TLSFinishedLen)
    n = TLSFinishedLen + 4
    msg0 = m .. "server finished"
    msg1 = m .. "client finished"
    msg0 = sub(msg0,1,n)
    msg1 = sub(msg1,1,n)
    if isclient then
      p9.write(hand,msg1)
      s = readn(hand,n)
      if s == nil or s ~= msg0 then
        return false
      end
    else
      p9.write(hand,msg0)
      s = readn(hand,n)
      if s == nil or s ~= msg1 then
        return false
      end
      return true
    end
  end
  local ctl,s,dir,data,hand,btoi
  ctl = p9.open("#a/tls/clone","rw")
  s = p9.read(ctl,8)
  print(s)
  dir = "#a/tls/"..s
  data = p9.open(dir.."/data","rw")
  hand = p9.open(dir.."/hand","rw")
  print(data,hand)
  btoi = {[false]=0,[true]=1}
  if fprint(ctl,"fd %d %s",fd,version)
     and p9.write(ctl,"version %s",version)
     and fprint(ctl,"secret %s %s %d %s",hashalg,encal,btoi[isclient],secret)
     and p9.write(ctl,"changecipher")
     and finished(hand,isclient)
     and p9.write(ctl, "opened")
  then
    p9.close(ctl)
    p9.close(hand)
    p9.close(fd)
    return data,dir
  end
  p9.close(hand)
  if data then p9.close(data) end
  if ctl then p9.close(ctl) end
  if hand then p9.close(hand) end
  return nil
end


encalgs = nil
hashalgs = nil

function init()
  local fd,s
  fd = p9.open("#a/tls/encalgs")
  s = p9.read(fd)
  p9.close(fd)
  encalgs = {}
  gsub(s,"(%w+)",function(a)
    encalgs[a] = true
  end)
  fd = p9.open("#a/tls/hashalgs")
  s = p9.read(fd)
  p9.close(fd)
  hashalgs = {}
  gsub(s,"(%w+)",function(a)
    hashalgs[a] = true
  end)
end

--[=[
#!/bin/lua
package.path = "/sys/lib/lua/lib?.lua"

require("gen")
require("enc")
require("net")
require("tls")

pushtls = tls.pushtls
enc64 = enc.enc64

dir,ctl = net.dial("tcp!io!443")
print(dir,ctl)
data = p9.open(dir.."/data","rw")
print(data)
tlsdata,tlsctl = pushtls(data,"md5","rc4_128",true,enc64("blackcat"))
-- "blackcat" must be encoded in base64
print(tlsdata,tlsctl)
--]=]
