find=string.find
sub=string.sub
gsub=string.gsub
match=string.match
dbg=print
push=table.insert

function dbgtab(t)
	for k,v in pairs(t) do
		print(k,v)
	end
end

function trim(s)
	return match(s,"^%s*(.-)%s*$")
end

function xfind(s,t,n) -- find t skippimg quote
	local n1,n2,u
	local q1='"'
	local q2="'"
	local chrset=q1..q2..sub(t,1,1)
	if not n then
		n=1
	end
	while n <= #s do
		n1,n2=find(s,"(["..chrset.."])",n)
		--dbg(n1,n2)
		if n1 == nil then
			return nil
		end
		u=sub(s,n1,n1)
		if u==q1 or u==q2 then
			n1,n2=find(s,u,n1+1,true)
			if n1==nil then
				return nil
			end
		elseif sub(s,n1,n1+#t-1)==t then
			return n1,n1+#t-1
		end
		n=n1+1
	end
end
--[[
dbg("#",xfind("abc'def'ghi","bc",1))
dbg("#",xfind("abc'def'ghi","cd",1))
dbg("#",xfind("abc'def'ghi","de",1))
dbg("#",xfind("abc'def'ghi","gh",1))
dbg("#",xfind("abc'def'ghi","hi",1))
--]]

function rfind(s,pat,plain) -- reverse find: find pat in s
	local m1,m2,n1,n2,n
	m2=0
	repeat
		n = m2+1
		n1,n2=m1,m2
		m1,m2=find(s,pat,n,plain)
	until m1 == nil
	return n1,n2
end

function xsplit(s)
	local n=1
	local n1,n2
	local t={}
	repeat
		s=match(s.." ","^%s*(.*)$")	-- trim left
		n1,n2=xfind(s," ")
		if n1 then
			push(t,sub(s,1,n1-1))
			s=sub(s,n1)
		end
	until n1==nil
	return t
end
--[[
t=xsplit(" abc  def ghi")
dbgtab(t)
t=xsplit(" abc xy='def yz' ghi  ")
dbgtab(t)
--]]

function split(s,sep,opt)
	-- sep: string
	-- opt:
	-- 		true: skip quote (for sep==nil)
	--    	true: trim (for sep~=nil)
	t={}
	function f(x)
		push(t,x)
	end
	if sep==nil and opt==nil then
		gsub(s,"%s*([^%s]+)",f)
	elseif sep==nil then
		t=xsplit(s)
	else
		local n
		local i = 1
		n = find(s,sep,i,true)
		while n do
			if n then
				push(t,sub(s,i,n-1))
				i = n + #sep
			end
			n = find(s,sep,i,true)
		end
		push(t,sub(s,i))
		if opt then
			for n,v in ipairs(t) do
				t[n] = trim(t[n])
			end
		end
	end
	--dbgtab(t)
	return t
end
--[[
function dpr(t) for k,v in pairs(t) do dbg(k,v) end end
dpr(split(" alice ","|"))
dpr(split(" alice | bob|carol","|"))
dpr(split(" alice | bob|carol","|",true))
dpr(split("| alice | bob","|",true))
dpr(split("alice bob","|"))
dpr(split("||alice | bob||carol","||",true))
os.exit()
--]]

function trans(s,tab)
	-- string translate using table
	local n,t,i,j,i0,j0,k0
	n = 1
	i0 = #s
	t=""
	repeat
		k0 = nil
		i0 = #s
		for k,v in pairs(tab) do
			--dbg("#1",s,k,n,i0)
			i,j=find(s,k,n,true)
			--dbg("#2",i,j)
			if i and i <= i0 then
				i0=i
				j0=j
				k0=k
			end
			--dbg("#3",i0,j0,k0)
		end
		if k0 == nil then
			return t..sub(s,n)
		end
		t = t..sub(s,n,i0-1)..tab[k0]
		--dbg("#4",t)
		n=j0+1
	until k0==nil
end
--[[ -- debug and usage
t={["alice"]=18,["bob"]=20}
dbg(trans("bagalicebbobalice",t)) --> bag18b2018
t={["["]="<code>",["]"]="</code>"}
dbg(trans("[blabla]",t))
--]]

return {
	trim=trim,
	xfind=xfind,
	rfind=rfind,
	split=split,
	xsplit=xsplit,
	trans=trans
}
