-- libnet ver. 1.1
-- lua ver. 5.2 compliant
-- you need 9lua
-- update: 2014/09/07
-- coded by Kenar (Kenji arisawa)

            -- some network stuffs --

str=require("str")
split = str.split
sub = string.gsub
match = string.match
find = string.find

local _ndb

function announce(addr)
  -- addr is: "tcp!*!port","tcp!ip!port"
  -- the ip is one of server's IP (look /net/iproute)
  -- example: addr="tcp!*!8080"
  -- ref: /sys/src/libc/9sys/announce.c
  local clone, ctl, n,s,r
  fd = p9.open("/net/cs","rw")
  s,r = p9.write(fd,addr)
  -- print(s,r)
  p9.seek(fd)
  s,r = p9.read(fd,1024) -- "/net/tcp/clone 8080"
  p9.close(fd)
  -- print(s,r)
  s = split(s)
  clone = s[1] -- "/net/tcp/clone"
  port = s[2]  -- "8080"
  ctl = p9.open(clone, "rw")
  n = p9.read(ctl) --> given n, i.e. /net/tcp/
  s,r = p9.write(ctl,"announce "..port)
  return "/net/tcp/"..n,ctl
end

function listen(dir)
  -- dir: /net/tcp/n
  local ctl,n
  ctl = p9.open(dir.."/listen","rw")
  if ctl == nil then
    return nil
  end
  n = p9.read(ctl)
  return "/net/tcp/"..n,ctl
end

function accept(lctl,ldir)
  -- ldir: /net/tcp/n
  -- ref: /sys/src/libc/9sys/announce.c
  local n,s,r
  n = split(ldir,"/")[3] -- n in /net/tcp/n
  p9.write(lctl,"accept "..n)
  -- ignore return value: see announce.c
  return p9.open(ldir.."/data","rw")
end

function reject(lctl,ldir)
  -- ldir: /net/tcp/n
  -- ref: /sys/src/libc/9sys/announce.c
  local n
  n = split(ldir,"/")[3] -- n in /net/tcp/n
  s,r = p9.write(lctl,"reject "..n)
  if r then
    return nil,r
  end
  return p9.open(ldir.."/data","rw")
end

function ndbinit(file)
  local function mkndb1(s)
    local t = {}
    gsub(s,"(%w+)=([^%s]*)", function(a,b)
      t[a] = b
    end)
    return t
  end

  local function mkndb2(t,s,u)
    gsub(s,"([^%s]+)", function(a)
      t[a] = u
    end)
    return t
  end

  local f,s,p,t,pp
  if file == nil then
    file = "/lib/ndb/local"
  end
  _ndb = {}
  f = false
  for line in io.lines(file) do
    s,p = match(line,"^(%s*)(%w+=.*)")
    if s then
      if #s == 0 then
        if f == true then
          t = mkndb1(t)
          _ndb = mkndb2(_ndb,pp,t)
        end
        f = false
        t = p
        pp = p
      else
        f = true
        t = t .. " " .. p
      end
    end
  end
end

function ndbquery(q, file)
  -- usage:
  --   ndbquery("sys=ar")
  if _ndb == nil then
    ndbinit(file)
  end
  return _ndb[q]
end

--[[
t = ndbquery("sys=ar").ip; print(t)
t = ndbquery("ip=202.250.160.40").sys; print(t)
--]]

function dial(addr)
  -- addr is "tcp!host!port"
  -- host is: ip, sysname, domname
  -- example:
  --   dial("tcp!202.250.160.40!80")
  --   dial("tcp!ar!80")
  --   dial("tcp!ar.aichi-u.ac.jp!80")
  -- IP(3)
  local s,ctl,net,host,port,cn,t,q,r
  gsub(addr,"^([^!]+)!([^!]*)!([%w]*)",function(n,a,b)
    net = n
    host = a
    port = b
  end)
  if net ~= "tcp" then
    error(net .. ": unsupported")
  end
  if match(host,"[%d]+%.[%d]+%.[%d]+%.[%d]+") then
    host = nil
  end
  if host and match(host,"^%w") then
    if find(host,"%.") then
      q = "dom="..host
    else
      q = "sys="..host
    end
    t = ndbquery(q)
    if t and t["ip"] then
      host = t["ip"]
    else
      t = dnsquery(host,"ip")
      host = t[1]
    end
  end
  if host == nil then
    return nil,"no such host"
  end
  addr = host.."!"..port
  ctl = p9.open("/net/tcp/clone","rw")
  cn = p9.read(ctl,10) -- the connection No.
  s,r = p9.write(ctl,"connect "..addr)
  if r then
    return nil,r
  end
  return "/net/tcp/"..cn,ctl
end

--[[
dir,ctl = dial("tcp!202.250.160.40!80")
data = p9.open(dir.."/data","rw")
p9.write(data,"GET /\r\n")
s = p9.read(data)
print(s)
p9.close(data)
p9.close(ctl) -- don't forget this one!
--]]

function dnsquery(a,q,net,timeout)
  -- a: addr, q:query
  -- usage:
  --   dnsquery("ar.aichi-u.ac.jp", "ip")
  --   dnsquery("ar.aichi-u.ac.jp", "ip","/net/dns")
  --   dnsquery("202.250.160.40", "ptr")
  -- dnsquery returns multiple IPs, so we return a table
  local t,u,r,s,fd
  if net == nil then
    net = "/net/dns"
  end
  if timeout == nil then
    timeout = 10
  end
  t = a,q
  if q == "ptr" then
    u = split(a,".")
    u = {[1] = u[4], [2] = u[3], [3] = u[2], [4] = u[1]}
    a = table.concat(u,".") .. ".in-addr.arpa"
  end
  -- print(q)
  t = {}
  p9.alarm(timeout)
  fd = p9.open(net,"rw")
  p9.seek(fd)
  s,r = p9.write(fd,a..' '..q)
  if r == nil then
    p9.seek(fd)
    -- Note: we cann't replace reading by using p9.read(fd)
    s,r = p9.read(fd,256)
    while s do
      s = split(s)
      table.insert(t,s[3])
      s,r = p9.read(fd,256)
    end
  end
  p9.close(fd)
  p9.alarm(0)
  return t,r
end

--[[
s,r = dnsquery("www.amazon.com", "ip")
for i,v in ipairs(s) do
  print(v)
end
--]]


return {
	announce=announce,
	listen=listen,
	accept=accept,
	reject=reject,
	ndbinit=ndbinit,
	ndbquery=ndbquery,
	dial=dial,
	dnsquery=dnsquery
}
